/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client.api;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface DeleteOption {
    public static final VersionIdDeleteOption Unconditionally = new VersionIdDeleteOption.Unconditionally();

    default public boolean cannotCoExistWith(DeleteOption option) {
        return false;
    }

    public static VersionIdDeleteOption ifVersionIdEquals(long versionId) {
        return new VersionIdDeleteOption.IfVersionIdEquals(versionId);
    }

    public static Set<DeleteOption> validate(DeleteOption ... args) {
        if (args == null || args.length == 0) {
            return Set.of(Unconditionally);
        }
        Arrays.stream(args).forEach(a -> {
            if (Arrays.stream(args).filter(c -> !c.equals(a)).anyMatch(c -> a.cannotCoExistWith((DeleteOption)c))) {
                throw new IllegalArgumentException("Incompatible " + DeleteOption.class.getSimpleName() + "s: " + Arrays.toString(args));
            }
        });
        return new HashSet<DeleteOption>(Arrays.asList(args));
    }

    public static Optional<Long> toVersionId(Collection<DeleteOption> options) {
        return options.stream().filter(o -> o instanceof VersionIdDeleteOption).findAny().map(o -> ((VersionIdDeleteOption)o).toVersionId());
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface VersionIdDeleteOption
    extends DeleteOption {
        public Long toVersionId();

        @Override
        default public boolean cannotCoExistWith(DeleteOption option) {
            return option instanceof VersionIdDeleteOption;
        }

        public record Unconditionally() implements VersionIdDeleteOption
        {
            @Override
            public Long toVersionId() {
                return null;
            }
        }

        public record IfVersionIdEquals(long versionId) implements VersionIdDeleteOption
        {
            public IfVersionIdEquals {
                if (versionId < 0L) {
                    throw new IllegalArgumentException("versionId cannot be less than 0 - was: " + versionId);
                }
            }

            @Override
            public Long toVersionId() {
                return this.versionId();
            }
        }
    }
}

