package io.streamnative.oxia.proto;

import static io.streamnative.oxia.proto.OxiaClientGrpc.getServiceDescriptor;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;


@javax.annotation.Generated(
value = "by ReactorGrpc generator",
comments = "Source: io/streamnative/oxia/client.proto")
public final class ReactorOxiaClientGrpc {
    private ReactorOxiaClientGrpc() {}

    public static ReactorOxiaClientStub newReactorStub(io.grpc.Channel channel) {
        return new ReactorOxiaClientStub(channel);
    }

    /**
     * <pre>
     * &#42;
     *  Oxia service that allows clients to discover shard-to-server assignments and
     *  submit batches of requests.
     * 
     *  Clients should connect to a random server to discover the shard-to-server
     *  assignments and then send the actual batched requests to the appropriate
     *  shard leader. In the future, this may be handled server-side in a proxy
     *  layer to allows clients to not be concerned with sharding.
     * </pre>
     */
    public static final class ReactorOxiaClientStub extends io.grpc.stub.AbstractStub<ReactorOxiaClientStub> {
        private OxiaClientGrpc.OxiaClientStub delegateStub;

        private ReactorOxiaClientStub(io.grpc.Channel channel) {
            super(channel);
            delegateStub = OxiaClientGrpc.newStub(channel);
        }

        private ReactorOxiaClientStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
            super(channel, callOptions);
            delegateStub = OxiaClientGrpc.newStub(channel).build(channel, callOptions);
        }

        @Override
        protected ReactorOxiaClientStub build(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
            return new ReactorOxiaClientStub(channel, callOptions);
        }

        /**
         * <pre>
         * &#42;
         *  Gets all shard-to-server assignments as a stream. Each set of assignments
         *  in the response stream will contain all the assignments to bring the client
         *  up to date. For example, if a shard is split, the stream will return a
         *  single response containing all the new shard assignments as opposed to
         *  multiple stream responses, each containing a single shard assignment.
         * 
         *  Clients should connect to a single random server which will stream the
         *  assignments for all shards on all servers.
         * </pre>
         */
        public reactor.core.publisher.Flux<io.streamnative.oxia.proto.ShardAssignments> getShardAssignments(reactor.core.publisher.Mono<io.streamnative.oxia.proto.ShardAssignmentsRequest> reactorRequest) {
            return com.salesforce.reactorgrpc.stub.ClientCalls.oneToMany(reactorRequest, delegateStub::getShardAssignments, getCallOptions());
        }

        /**
         * <pre>
         * &#42;
         *  Batches put, delete and delete_range requests.
         * 
         *  Clients should send this request to the shard leader. In the future,
         *  this may be handled server-side in a proxy layer.
         * </pre>
         */
        public reactor.core.publisher.Mono<io.streamnative.oxia.proto.WriteResponse> write(reactor.core.publisher.Mono<io.streamnative.oxia.proto.WriteRequest> reactorRequest) {
            return com.salesforce.reactorgrpc.stub.ClientCalls.oneToOne(reactorRequest, delegateStub::write, getCallOptions());
        }

        /**
         * <pre>
         * &#42;
         *  Batches get requests.
         * 
         *  Clients should send this request to the shard leader. In the future,
         *  this may be handled server-side in a proxy layer.
         * </pre>
         */
        public reactor.core.publisher.Flux<io.streamnative.oxia.proto.ReadResponse> read(reactor.core.publisher.Mono<io.streamnative.oxia.proto.ReadRequest> reactorRequest) {
            return com.salesforce.reactorgrpc.stub.ClientCalls.oneToMany(reactorRequest, delegateStub::read, getCallOptions());
        }

        /**
         * <pre>
         * &#42;
         *  Requests all the keys between a range of keys.
         * 
         *  Clients should send an equivalent request to all respective shards.
         * </pre>
         */
        public reactor.core.publisher.Flux<io.streamnative.oxia.proto.ListResponse> list(reactor.core.publisher.Mono<io.streamnative.oxia.proto.ListRequest> reactorRequest) {
            return com.salesforce.reactorgrpc.stub.ClientCalls.oneToMany(reactorRequest, delegateStub::list, getCallOptions());
        }

        public reactor.core.publisher.Flux<io.streamnative.oxia.proto.NotificationBatch> getNotifications(reactor.core.publisher.Mono<io.streamnative.oxia.proto.NotificationsRequest> reactorRequest) {
            return com.salesforce.reactorgrpc.stub.ClientCalls.oneToMany(reactorRequest, delegateStub::getNotifications, getCallOptions());
        }

        /**
         * <pre>
         * 
         *  Creates a new client session. Sessions are kept alive by regularly sending
         *  heartbeats via the KeepAlive rpc.
         * </pre>
         */
        public reactor.core.publisher.Mono<io.streamnative.oxia.proto.CreateSessionResponse> createSession(reactor.core.publisher.Mono<io.streamnative.oxia.proto.CreateSessionRequest> reactorRequest) {
            return com.salesforce.reactorgrpc.stub.ClientCalls.oneToOne(reactorRequest, delegateStub::createSession, getCallOptions());
        }

        /**
         * <pre>
         * 
         *  Sends a heartbeat to prevent the session from timing out.
         * </pre>
         */
        public reactor.core.publisher.Mono<io.streamnative.oxia.proto.KeepAliveResponse> keepAlive(reactor.core.publisher.Mono<io.streamnative.oxia.proto.SessionHeartbeat> reactorRequest) {
            return com.salesforce.reactorgrpc.stub.ClientCalls.oneToOne(reactorRequest, delegateStub::keepAlive, getCallOptions());
        }

        /**
         * <pre>
         * 
         *  Closes a session and removes all ephemeral values associated with it.
         * </pre>
         */
        public reactor.core.publisher.Mono<io.streamnative.oxia.proto.CloseSessionResponse> closeSession(reactor.core.publisher.Mono<io.streamnative.oxia.proto.CloseSessionRequest> reactorRequest) {
            return com.salesforce.reactorgrpc.stub.ClientCalls.oneToOne(reactorRequest, delegateStub::closeSession, getCallOptions());
        }

        /**
         * <pre>
         * &#42;
         *  Gets all shard-to-server assignments as a stream. Each set of assignments
         *  in the response stream will contain all the assignments to bring the client
         *  up to date. For example, if a shard is split, the stream will return a
         *  single response containing all the new shard assignments as opposed to
         *  multiple stream responses, each containing a single shard assignment.
         * 
         *  Clients should connect to a single random server which will stream the
         *  assignments for all shards on all servers.
         * </pre>
         */
        public reactor.core.publisher.Flux<io.streamnative.oxia.proto.ShardAssignments> getShardAssignments(io.streamnative.oxia.proto.ShardAssignmentsRequest reactorRequest) {
           return com.salesforce.reactorgrpc.stub.ClientCalls.oneToMany(reactor.core.publisher.Mono.just(reactorRequest), delegateStub::getShardAssignments, getCallOptions());
        }

        /**
         * <pre>
         * &#42;
         *  Batches put, delete and delete_range requests.
         * 
         *  Clients should send this request to the shard leader. In the future,
         *  this may be handled server-side in a proxy layer.
         * </pre>
         */
        public reactor.core.publisher.Mono<io.streamnative.oxia.proto.WriteResponse> write(io.streamnative.oxia.proto.WriteRequest reactorRequest) {
           return com.salesforce.reactorgrpc.stub.ClientCalls.oneToOne(reactor.core.publisher.Mono.just(reactorRequest), delegateStub::write, getCallOptions());
        }

        /**
         * <pre>
         * &#42;
         *  Batches get requests.
         * 
         *  Clients should send this request to the shard leader. In the future,
         *  this may be handled server-side in a proxy layer.
         * </pre>
         */
        public reactor.core.publisher.Flux<io.streamnative.oxia.proto.ReadResponse> read(io.streamnative.oxia.proto.ReadRequest reactorRequest) {
           return com.salesforce.reactorgrpc.stub.ClientCalls.oneToMany(reactor.core.publisher.Mono.just(reactorRequest), delegateStub::read, getCallOptions());
        }

        /**
         * <pre>
         * &#42;
         *  Requests all the keys between a range of keys.
         * 
         *  Clients should send an equivalent request to all respective shards.
         * </pre>
         */
        public reactor.core.publisher.Flux<io.streamnative.oxia.proto.ListResponse> list(io.streamnative.oxia.proto.ListRequest reactorRequest) {
           return com.salesforce.reactorgrpc.stub.ClientCalls.oneToMany(reactor.core.publisher.Mono.just(reactorRequest), delegateStub::list, getCallOptions());
        }

        public reactor.core.publisher.Flux<io.streamnative.oxia.proto.NotificationBatch> getNotifications(io.streamnative.oxia.proto.NotificationsRequest reactorRequest) {
           return com.salesforce.reactorgrpc.stub.ClientCalls.oneToMany(reactor.core.publisher.Mono.just(reactorRequest), delegateStub::getNotifications, getCallOptions());
        }

        /**
         * <pre>
         * 
         *  Creates a new client session. Sessions are kept alive by regularly sending
         *  heartbeats via the KeepAlive rpc.
         * </pre>
         */
        public reactor.core.publisher.Mono<io.streamnative.oxia.proto.CreateSessionResponse> createSession(io.streamnative.oxia.proto.CreateSessionRequest reactorRequest) {
           return com.salesforce.reactorgrpc.stub.ClientCalls.oneToOne(reactor.core.publisher.Mono.just(reactorRequest), delegateStub::createSession, getCallOptions());
        }

        /**
         * <pre>
         * 
         *  Sends a heartbeat to prevent the session from timing out.
         * </pre>
         */
        public reactor.core.publisher.Mono<io.streamnative.oxia.proto.KeepAliveResponse> keepAlive(io.streamnative.oxia.proto.SessionHeartbeat reactorRequest) {
           return com.salesforce.reactorgrpc.stub.ClientCalls.oneToOne(reactor.core.publisher.Mono.just(reactorRequest), delegateStub::keepAlive, getCallOptions());
        }

        /**
         * <pre>
         * 
         *  Closes a session and removes all ephemeral values associated with it.
         * </pre>
         */
        public reactor.core.publisher.Mono<io.streamnative.oxia.proto.CloseSessionResponse> closeSession(io.streamnative.oxia.proto.CloseSessionRequest reactorRequest) {
           return com.salesforce.reactorgrpc.stub.ClientCalls.oneToOne(reactor.core.publisher.Mono.just(reactorRequest), delegateStub::closeSession, getCallOptions());
        }

    }

    /**
     * <pre>
     * &#42;
     *  Oxia service that allows clients to discover shard-to-server assignments and
     *  submit batches of requests.
     * 
     *  Clients should connect to a random server to discover the shard-to-server
     *  assignments and then send the actual batched requests to the appropriate
     *  shard leader. In the future, this may be handled server-side in a proxy
     *  layer to allows clients to not be concerned with sharding.
     * </pre>
     */
    public static abstract class OxiaClientImplBase implements io.grpc.BindableService {

        /**
         * <pre>
         * &#42;
         *  Gets all shard-to-server assignments as a stream. Each set of assignments
         *  in the response stream will contain all the assignments to bring the client
         *  up to date. For example, if a shard is split, the stream will return a
         *  single response containing all the new shard assignments as opposed to
         *  multiple stream responses, each containing a single shard assignment.
         * 
         *  Clients should connect to a single random server which will stream the
         *  assignments for all shards on all servers.
         * </pre>
         */
        public reactor.core.publisher.Flux<io.streamnative.oxia.proto.ShardAssignments> getShardAssignments(io.streamnative.oxia.proto.ShardAssignmentsRequest request) {
            return getShardAssignments(reactor.core.publisher.Mono.just(request));
        }

        /**
         * <pre>
         * &#42;
         *  Gets all shard-to-server assignments as a stream. Each set of assignments
         *  in the response stream will contain all the assignments to bring the client
         *  up to date. For example, if a shard is split, the stream will return a
         *  single response containing all the new shard assignments as opposed to
         *  multiple stream responses, each containing a single shard assignment.
         * 
         *  Clients should connect to a single random server which will stream the
         *  assignments for all shards on all servers.
         * </pre>
         */
        public reactor.core.publisher.Flux<io.streamnative.oxia.proto.ShardAssignments> getShardAssignments(reactor.core.publisher.Mono<io.streamnative.oxia.proto.ShardAssignmentsRequest> request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         * &#42;
         *  Batches put, delete and delete_range requests.
         * 
         *  Clients should send this request to the shard leader. In the future,
         *  this may be handled server-side in a proxy layer.
         * </pre>
         */
        public reactor.core.publisher.Mono<io.streamnative.oxia.proto.WriteResponse> write(io.streamnative.oxia.proto.WriteRequest request) {
            return write(reactor.core.publisher.Mono.just(request));
        }

        /**
         * <pre>
         * &#42;
         *  Batches put, delete and delete_range requests.
         * 
         *  Clients should send this request to the shard leader. In the future,
         *  this may be handled server-side in a proxy layer.
         * </pre>
         */
        public reactor.core.publisher.Mono<io.streamnative.oxia.proto.WriteResponse> write(reactor.core.publisher.Mono<io.streamnative.oxia.proto.WriteRequest> request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         * &#42;
         *  Batches get requests.
         * 
         *  Clients should send this request to the shard leader. In the future,
         *  this may be handled server-side in a proxy layer.
         * </pre>
         */
        public reactor.core.publisher.Flux<io.streamnative.oxia.proto.ReadResponse> read(io.streamnative.oxia.proto.ReadRequest request) {
            return read(reactor.core.publisher.Mono.just(request));
        }

        /**
         * <pre>
         * &#42;
         *  Batches get requests.
         * 
         *  Clients should send this request to the shard leader. In the future,
         *  this may be handled server-side in a proxy layer.
         * </pre>
         */
        public reactor.core.publisher.Flux<io.streamnative.oxia.proto.ReadResponse> read(reactor.core.publisher.Mono<io.streamnative.oxia.proto.ReadRequest> request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         * &#42;
         *  Requests all the keys between a range of keys.
         * 
         *  Clients should send an equivalent request to all respective shards.
         * </pre>
         */
        public reactor.core.publisher.Flux<io.streamnative.oxia.proto.ListResponse> list(io.streamnative.oxia.proto.ListRequest request) {
            return list(reactor.core.publisher.Mono.just(request));
        }

        /**
         * <pre>
         * &#42;
         *  Requests all the keys between a range of keys.
         * 
         *  Clients should send an equivalent request to all respective shards.
         * </pre>
         */
        public reactor.core.publisher.Flux<io.streamnative.oxia.proto.ListResponse> list(reactor.core.publisher.Mono<io.streamnative.oxia.proto.ListRequest> request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        public reactor.core.publisher.Flux<io.streamnative.oxia.proto.NotificationBatch> getNotifications(io.streamnative.oxia.proto.NotificationsRequest request) {
            return getNotifications(reactor.core.publisher.Mono.just(request));
        }

        public reactor.core.publisher.Flux<io.streamnative.oxia.proto.NotificationBatch> getNotifications(reactor.core.publisher.Mono<io.streamnative.oxia.proto.NotificationsRequest> request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         * 
         *  Creates a new client session. Sessions are kept alive by regularly sending
         *  heartbeats via the KeepAlive rpc.
         * </pre>
         */
        public reactor.core.publisher.Mono<io.streamnative.oxia.proto.CreateSessionResponse> createSession(io.streamnative.oxia.proto.CreateSessionRequest request) {
            return createSession(reactor.core.publisher.Mono.just(request));
        }

        /**
         * <pre>
         * 
         *  Creates a new client session. Sessions are kept alive by regularly sending
         *  heartbeats via the KeepAlive rpc.
         * </pre>
         */
        public reactor.core.publisher.Mono<io.streamnative.oxia.proto.CreateSessionResponse> createSession(reactor.core.publisher.Mono<io.streamnative.oxia.proto.CreateSessionRequest> request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         * 
         *  Sends a heartbeat to prevent the session from timing out.
         * </pre>
         */
        public reactor.core.publisher.Mono<io.streamnative.oxia.proto.KeepAliveResponse> keepAlive(io.streamnative.oxia.proto.SessionHeartbeat request) {
            return keepAlive(reactor.core.publisher.Mono.just(request));
        }

        /**
         * <pre>
         * 
         *  Sends a heartbeat to prevent the session from timing out.
         * </pre>
         */
        public reactor.core.publisher.Mono<io.streamnative.oxia.proto.KeepAliveResponse> keepAlive(reactor.core.publisher.Mono<io.streamnative.oxia.proto.SessionHeartbeat> request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         * 
         *  Closes a session and removes all ephemeral values associated with it.
         * </pre>
         */
        public reactor.core.publisher.Mono<io.streamnative.oxia.proto.CloseSessionResponse> closeSession(io.streamnative.oxia.proto.CloseSessionRequest request) {
            return closeSession(reactor.core.publisher.Mono.just(request));
        }

        /**
         * <pre>
         * 
         *  Closes a session and removes all ephemeral values associated with it.
         * </pre>
         */
        public reactor.core.publisher.Mono<io.streamnative.oxia.proto.CloseSessionResponse> closeSession(reactor.core.publisher.Mono<io.streamnative.oxia.proto.CloseSessionRequest> request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
            return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
                    .addMethod(
                            io.streamnative.oxia.proto.OxiaClientGrpc.getGetShardAssignmentsMethod(),
                            asyncServerStreamingCall(
                                    new MethodHandlers<
                                            io.streamnative.oxia.proto.ShardAssignmentsRequest,
                                            io.streamnative.oxia.proto.ShardAssignments>(
                                            this, METHODID_GET_SHARD_ASSIGNMENTS)))
                    .addMethod(
                            io.streamnative.oxia.proto.OxiaClientGrpc.getWriteMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.streamnative.oxia.proto.WriteRequest,
                                            io.streamnative.oxia.proto.WriteResponse>(
                                            this, METHODID_WRITE)))
                    .addMethod(
                            io.streamnative.oxia.proto.OxiaClientGrpc.getReadMethod(),
                            asyncServerStreamingCall(
                                    new MethodHandlers<
                                            io.streamnative.oxia.proto.ReadRequest,
                                            io.streamnative.oxia.proto.ReadResponse>(
                                            this, METHODID_READ)))
                    .addMethod(
                            io.streamnative.oxia.proto.OxiaClientGrpc.getListMethod(),
                            asyncServerStreamingCall(
                                    new MethodHandlers<
                                            io.streamnative.oxia.proto.ListRequest,
                                            io.streamnative.oxia.proto.ListResponse>(
                                            this, METHODID_LIST)))
                    .addMethod(
                            io.streamnative.oxia.proto.OxiaClientGrpc.getGetNotificationsMethod(),
                            asyncServerStreamingCall(
                                    new MethodHandlers<
                                            io.streamnative.oxia.proto.NotificationsRequest,
                                            io.streamnative.oxia.proto.NotificationBatch>(
                                            this, METHODID_GET_NOTIFICATIONS)))
                    .addMethod(
                            io.streamnative.oxia.proto.OxiaClientGrpc.getCreateSessionMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.streamnative.oxia.proto.CreateSessionRequest,
                                            io.streamnative.oxia.proto.CreateSessionResponse>(
                                            this, METHODID_CREATE_SESSION)))
                    .addMethod(
                            io.streamnative.oxia.proto.OxiaClientGrpc.getKeepAliveMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.streamnative.oxia.proto.SessionHeartbeat,
                                            io.streamnative.oxia.proto.KeepAliveResponse>(
                                            this, METHODID_KEEP_ALIVE)))
                    .addMethod(
                            io.streamnative.oxia.proto.OxiaClientGrpc.getCloseSessionMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.streamnative.oxia.proto.CloseSessionRequest,
                                            io.streamnative.oxia.proto.CloseSessionResponse>(
                                            this, METHODID_CLOSE_SESSION)))
                    .build();
        }

        protected io.grpc.CallOptions getCallOptions(int methodId) {
            return null;
        }

        protected Throwable onErrorMap(Throwable throwable) {
            return com.salesforce.reactorgrpc.stub.ServerCalls.prepareError(throwable);
        }
    }

    public static final int METHODID_GET_SHARD_ASSIGNMENTS = 0;
    public static final int METHODID_WRITE = 1;
    public static final int METHODID_READ = 2;
    public static final int METHODID_LIST = 3;
    public static final int METHODID_GET_NOTIFICATIONS = 4;
    public static final int METHODID_CREATE_SESSION = 5;
    public static final int METHODID_KEEP_ALIVE = 6;
    public static final int METHODID_CLOSE_SESSION = 7;

    private static final class MethodHandlers<Req, Resp> implements
            io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
            io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
            io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
            io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final OxiaClientImplBase serviceImpl;
        private final int methodId;

        MethodHandlers(OxiaClientImplBase serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch (methodId) {
                case METHODID_GET_SHARD_ASSIGNMENTS:
                    com.salesforce.reactorgrpc.stub.ServerCalls.oneToMany((io.streamnative.oxia.proto.ShardAssignmentsRequest) request,
                            (io.grpc.stub.StreamObserver<io.streamnative.oxia.proto.ShardAssignments>) responseObserver,
                            serviceImpl::getShardAssignments, serviceImpl::onErrorMap);
                    break;
                case METHODID_WRITE:
                    com.salesforce.reactorgrpc.stub.ServerCalls.oneToOne((io.streamnative.oxia.proto.WriteRequest) request,
                            (io.grpc.stub.StreamObserver<io.streamnative.oxia.proto.WriteResponse>) responseObserver,
                            serviceImpl::write, serviceImpl::onErrorMap);
                    break;
                case METHODID_READ:
                    com.salesforce.reactorgrpc.stub.ServerCalls.oneToMany((io.streamnative.oxia.proto.ReadRequest) request,
                            (io.grpc.stub.StreamObserver<io.streamnative.oxia.proto.ReadResponse>) responseObserver,
                            serviceImpl::read, serviceImpl::onErrorMap);
                    break;
                case METHODID_LIST:
                    com.salesforce.reactorgrpc.stub.ServerCalls.oneToMany((io.streamnative.oxia.proto.ListRequest) request,
                            (io.grpc.stub.StreamObserver<io.streamnative.oxia.proto.ListResponse>) responseObserver,
                            serviceImpl::list, serviceImpl::onErrorMap);
                    break;
                case METHODID_GET_NOTIFICATIONS:
                    com.salesforce.reactorgrpc.stub.ServerCalls.oneToMany((io.streamnative.oxia.proto.NotificationsRequest) request,
                            (io.grpc.stub.StreamObserver<io.streamnative.oxia.proto.NotificationBatch>) responseObserver,
                            serviceImpl::getNotifications, serviceImpl::onErrorMap);
                    break;
                case METHODID_CREATE_SESSION:
                    com.salesforce.reactorgrpc.stub.ServerCalls.oneToOne((io.streamnative.oxia.proto.CreateSessionRequest) request,
                            (io.grpc.stub.StreamObserver<io.streamnative.oxia.proto.CreateSessionResponse>) responseObserver,
                            serviceImpl::createSession, serviceImpl::onErrorMap);
                    break;
                case METHODID_KEEP_ALIVE:
                    com.salesforce.reactorgrpc.stub.ServerCalls.oneToOne((io.streamnative.oxia.proto.SessionHeartbeat) request,
                            (io.grpc.stub.StreamObserver<io.streamnative.oxia.proto.KeepAliveResponse>) responseObserver,
                            serviceImpl::keepAlive, serviceImpl::onErrorMap);
                    break;
                case METHODID_CLOSE_SESSION:
                    com.salesforce.reactorgrpc.stub.ServerCalls.oneToOne((io.streamnative.oxia.proto.CloseSessionRequest) request,
                            (io.grpc.stub.StreamObserver<io.streamnative.oxia.proto.CloseSessionResponse>) responseObserver,
                            serviceImpl::closeSession, serviceImpl::onErrorMap);
                    break;
                default:
                    throw new java.lang.AssertionError();
            }
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public io.grpc.stub.StreamObserver<Req> invoke(io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch (methodId) {
                default:
                    throw new java.lang.AssertionError();
            }
        }
    }

}
