/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsarmetadatastoreoxia;

import io.streamnative.oxia.client.OxiaClientBuilder;
import io.streamnative.oxia.client.api.AsyncOxiaClient;
import io.streamnative.oxia.client.api.DeleteOption;
import io.streamnative.oxia.client.api.GetResult;
import io.streamnative.oxia.client.api.KeyAlreadyExistsException;
import io.streamnative.oxia.client.api.Notification;
import io.streamnative.oxia.client.api.PutOption;
import io.streamnative.oxia.client.api.PutResult;
import io.streamnative.oxia.client.api.UnexpectedVersionIdException;
import io.streamnative.oxia.client.api.Version;
import java.time.Duration;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import lombok.NonNull;
import org.apache.pulsar.metadata.api.MetadataEventSynchronizer;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.Notification;
import org.apache.pulsar.metadata.api.NotificationType;
import org.apache.pulsar.metadata.api.Stat;
import org.apache.pulsar.metadata.api.extended.CreateOption;
import org.apache.pulsar.metadata.impl.AbstractMetadataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OxiaMetadataStore
extends AbstractMetadataStore {
    private static final Logger log = LoggerFactory.getLogger(OxiaMetadataStore.class);
    private final AsyncOxiaClient client;
    private final String identity;
    private final Optional<MetadataEventSynchronizer> synchronizer;

    OxiaMetadataStore(@NonNull String serviceAddress, @NonNull String namespace, @NonNull MetadataStoreConfig metadataStoreConfig, boolean enableSessionWatcher) throws Exception {
        super("oxia-metadata");
        if (serviceAddress == null) {
            throw new NullPointerException("serviceAddress is marked non-null but is null");
        }
        if (namespace == null) {
            throw new NullPointerException("namespace is marked non-null but is null");
        }
        if (metadataStoreConfig == null) {
            throw new NullPointerException("metadataStoreConfig is marked non-null but is null");
        }
        int linger = metadataStoreConfig.getBatchingMaxDelayMillis();
        if (!metadataStoreConfig.isBatchingEnabled()) {
            linger = 0;
        }
        this.synchronizer = Optional.ofNullable(metadataStoreConfig.getSynchronizer());
        this.identity = UUID.randomUUID().toString();
        this.client = (AsyncOxiaClient)new OxiaClientBuilder(serviceAddress).clientIdentifier(this.identity).namespace(namespace).sessionTimeout(Duration.ofMillis(metadataStoreConfig.getSessionTimeoutMillis())).batchLinger(Duration.ofMillis(linger)).maxRequestsPerBatch(metadataStoreConfig.getBatchingMaxOperations()).asyncClient().get();
        this.client.notifications(this::notificationCallback);
        super.registerSyncLister(Optional.ofNullable(metadataStoreConfig.getSynchronizer()));
    }

    private void notificationCallback(io.streamnative.oxia.client.api.Notification notification) {
        if (notification.key().startsWith("__oxia")) {
            return;
        }
        if (notification instanceof Notification.KeyCreated) {
            Notification.KeyCreated keyCreated = (Notification.KeyCreated)notification;
            this.receivedNotification(new Notification(NotificationType.Created, keyCreated.key()));
            this.notifyParentChildrenChanged(keyCreated.key());
        } else if (notification instanceof Notification.KeyModified) {
            Notification.KeyModified keyModified = (Notification.KeyModified)notification;
            this.receivedNotification(new Notification(NotificationType.Modified, keyModified.key()));
        } else if (notification instanceof Notification.KeyDeleted) {
            Notification.KeyDeleted keyDeleted = (Notification.KeyDeleted)notification;
            this.receivedNotification(new Notification(NotificationType.Deleted, keyDeleted.key()));
            this.notifyParentChildrenChanged(keyDeleted.key());
        } else {
            log.error("Unknown notification type {}", (Object)notification);
        }
    }

    Optional<org.apache.pulsar.metadata.api.GetResult> convertGetResult(String path, GetResult result) {
        if (result == null) {
            return Optional.empty();
        }
        return Optional.of(result).map(oxiaResult -> new org.apache.pulsar.metadata.api.GetResult(oxiaResult.getValue(), this.convertStat(path, oxiaResult.getVersion())));
    }

    Stat convertStat(String path, Version version) {
        return new Stat(path, version.versionId(), version.createdTimestamp(), version.modifiedTimestamp(), version.sessionId().isPresent(), version.clientIdentifier().stream().anyMatch(this.identity::equals), version.modificationsCount() == 0L);
    }

    protected CompletableFuture<List<String>> getChildrenFromStore(String path) {
        String pathWithSlash = path + "/";
        return this.client.list(pathWithSlash, pathWithSlash + "/").thenApply(children -> children.stream().map(child -> child.substring(pathWithSlash.length())).toList());
    }

    protected CompletableFuture<Boolean> existsFromStore(String path) {
        return this.client.get(path).thenApply(Objects::nonNull);
    }

    protected CompletableFuture<Optional<org.apache.pulsar.metadata.api.GetResult>> storeGet(String path) {
        return this.client.get(path).thenApply(res -> this.convertGetResult(path, (GetResult)res));
    }

    protected CompletableFuture<Void> storeDelete(String path, Optional<Long> expectedVersion) {
        return this.getChildrenFromStore(path).thenCompose(children -> {
            if (!children.isEmpty()) {
                return CompletableFuture.failedFuture((Throwable)new MetadataStoreException("Key '" + path + "' has children"));
            }
            DeleteOption.VersionIdDeleteOption delOption = expectedVersion.map(DeleteOption::ifVersionIdEquals).orElse(DeleteOption.Unconditionally);
            CompletableFuture result = this.client.delete(path, new DeleteOption[]{delOption});
            return ((CompletableFuture)result.thenCompose(exists -> {
                if (!exists.booleanValue()) {
                    return CompletableFuture.failedFuture((Throwable)new MetadataStoreException.NotFoundException("Key '" + path + "' does not exist"));
                }
                return CompletableFuture.completedFuture(null);
            })).exceptionallyCompose(this::convertException);
        });
    }

    protected CompletableFuture<Stat> storePut(String path, byte[] data, Optional<Long> optExpectedVersion, EnumSet<CreateOption> options) {
        CompletableFuture<Void> parentsCreated = this.createParents(path);
        return parentsCreated.thenCompose(__ -> {
            PutOption[] putOptionArray;
            CompletionStage<String> actualPath;
            Optional<Long> expectedVersion = optExpectedVersion;
            if (expectedVersion.isPresent() && (Long)expectedVersion.get() != -1L && options.contains(CreateOption.Sequential)) {
                return CompletableFuture.failedFuture((Throwable)new MetadataStoreException("Can't have expectedVersion and Sequential at the same time"));
            }
            if (options.contains(CreateOption.Sequential)) {
                String parent = OxiaMetadataStore.parent((String)path);
                String parentPath = parent == null ? "/" : parent;
                actualPath = this.client.put(parentPath, new byte[0], new PutOption[0]).thenApply(r -> String.format("%s%010d", path, r.version().modificationsCount()));
                expectedVersion = Optional.of(-1L);
            } else {
                actualPath = CompletableFuture.completedFuture(path);
            }
            PutOption.VersionIdPutOption versionCondition = expectedVersion.map(ver -> {
                if (ver == -1L) {
                    return PutOption.IfRecordDoesNotExist;
                }
                return PutOption.ifVersionIdEquals((long)ver);
            }).orElse(PutOption.Unconditionally);
            if (options.contains(CreateOption.Ephemeral)) {
                PutOption[] putOptionArray2 = new PutOption[2];
                putOptionArray2[0] = PutOption.AsEphemeralRecord;
                putOptionArray = putOptionArray2;
                putOptionArray2[1] = versionCondition;
            } else {
                PutOption[] putOptionArray3 = new PutOption[1];
                putOptionArray = putOptionArray3;
                putOptionArray3[0] = versionCondition;
            }
            PutOption[] putOptions = putOptionArray;
            return ((CompletableFuture)((CompletableFuture)((CompletableFuture)actualPath).thenCompose(aPath -> this.client.put(aPath, data, putOptions).thenApply(res -> new PathWithPutResult((String)aPath, (PutResult)res)))).thenApply(res -> this.convertStat(res.path(), res.result().version()))).exceptionallyCompose(this::convertException);
        });
    }

    private <T> CompletionStage<T> convertException(Throwable ex) {
        return ex.getCause() instanceof UnexpectedVersionIdException || ex.getCause() instanceof KeyAlreadyExistsException ? CompletableFuture.failedFuture((Throwable)new MetadataStoreException.BadVersionException(ex.getCause())) : CompletableFuture.failedFuture(ex.getCause());
    }

    private CompletableFuture<Void> createParents(String path) {
        String parent = OxiaMetadataStore.parent((String)path);
        if (parent == null || parent.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        return ((CompletableFuture)this.exists(parent).thenCompose(exists -> {
            if (exists.booleanValue()) {
                return CompletableFuture.completedFuture(null);
            }
            return this.client.put(parent, new byte[0], new PutOption[]{PutOption.IfRecordDoesNotExist}).thenCompose(__ -> this.createParents(parent));
        })).exceptionallyCompose(ex -> {
            if (ex.getCause() instanceof KeyAlreadyExistsException) {
                return CompletableFuture.completedFuture(null);
            }
            return CompletableFuture.failedFuture(ex.getCause());
        });
    }

    public void close() throws Exception {
        if (this.client != null) {
            this.client.close();
        }
        super.close();
    }

    public Optional<MetadataEventSynchronizer> getMetadataEventSynchronizer() {
        return this.synchronizer;
    }

    private record PathWithPutResult(String path, PutResult result) {
    }
}

