/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.core.publisher;

import io.streamnative.pulsarmetadatastoreoxia.shaded.org.reactivestreams.Subscription;
import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.core.CoreSubscriber;
import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.core.publisher.Operators;
import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.util.context.Context;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;

final class MonoToCompletableFuture<T>
extends CompletableFuture<T>
implements CoreSubscriber<T> {
    final AtomicReference<Subscription> ref = new AtomicReference();
    final boolean cancelSourceOnNext;

    MonoToCompletableFuture(boolean sourceCanEmitMoreThanOnce) {
        this.cancelSourceOnNext = sourceCanEmitMoreThanOnce;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Subscription s2;
        boolean cancelled = super.cancel(mayInterruptIfRunning);
        if (cancelled && (s2 = (Subscription)this.ref.getAndSet(null)) != null) {
            s2.cancel();
        }
        return cancelled;
    }

    @Override
    public void onSubscribe(Subscription s2) {
        if (Operators.validate(this.ref.getAndSet(s2), s2)) {
            s2.request(Long.MAX_VALUE);
        } else {
            s2.cancel();
        }
    }

    @Override
    public void onNext(T t2) {
        Subscription s2 = this.ref.getAndSet(null);
        if (s2 != null) {
            this.complete(t2);
            if (this.cancelSourceOnNext) {
                s2.cancel();
            }
        } else {
            Operators.onNextDropped(t2, this.currentContext());
        }
    }

    @Override
    public void onError(Throwable t2) {
        if (this.ref.getAndSet(null) != null) {
            this.completeExceptionally(t2);
        }
    }

    @Override
    public void onComplete() {
        if (this.ref.getAndSet(null) != null) {
            this.complete(null);
        }
    }

    @Override
    public Context currentContext() {
        return Context.empty();
    }
}

