/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.core.publisher;

import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.core.CoreSubscriber;
import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.core.Fuseable;
import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.core.Scannable;
import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.core.publisher.InternalMonoOperator;
import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.core.publisher.Mono;
import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.core.publisher.MonoNameFuseable;
import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.util.annotation.Nullable;
import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.util.function.Tuple2;
import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.util.function.Tuples;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

final class MonoName<T>
extends InternalMonoOperator<T, T> {
    final String name;
    final List<Tuple2<String, String>> tagsWithDuplicates;

    static <T> Mono<T> createOrAppend(Mono<T> source, String name) {
        Objects.requireNonNull(name, "name");
        if (source instanceof MonoName) {
            MonoName s2 = (MonoName)source;
            return new MonoName<T>(s2.source, name, s2.tagsWithDuplicates);
        }
        if (source instanceof MonoNameFuseable) {
            MonoNameFuseable s3 = (MonoNameFuseable)source;
            return new MonoNameFuseable(s3.source, name, s3.tagsWithDuplicates);
        }
        if (source instanceof Fuseable) {
            return new MonoNameFuseable<T>(source, name, null);
        }
        return new MonoName<T>(source, name, null);
    }

    static <T> Mono<T> createOrAppend(Mono<T> source, String tagName, String tagValue) {
        Objects.requireNonNull(tagName, "tagName");
        Objects.requireNonNull(tagValue, "tagValue");
        Tuple2<String, String> newTag = Tuples.of(tagName, tagValue);
        if (source instanceof MonoName) {
            List<Tuple2<String, String>> tags;
            MonoName s2 = (MonoName)source;
            if (s2.tagsWithDuplicates != null) {
                tags = new LinkedList<Tuple2<String, String>>(s2.tagsWithDuplicates);
                tags.add(newTag);
            } else {
                tags = Collections.singletonList(newTag);
            }
            return new MonoName<T>(s2.source, s2.name, tags);
        }
        if (source instanceof MonoNameFuseable) {
            List<Tuple2<String, String>> tags;
            MonoNameFuseable s3 = (MonoNameFuseable)source;
            if (s3.tagsWithDuplicates != null) {
                tags = new LinkedList<Tuple2<String, String>>(s3.tagsWithDuplicates);
                tags.add(newTag);
            } else {
                tags = Collections.singletonList(newTag);
            }
            return new MonoNameFuseable(s3.source, s3.name, tags);
        }
        if (source instanceof Fuseable) {
            return new MonoNameFuseable<T>(source, null, Collections.singletonList(newTag));
        }
        return new MonoName<T>(source, null, Collections.singletonList(newTag));
    }

    MonoName(Mono<? extends T> source, @Nullable String name, @Nullable List<Tuple2<String, String>> tags) {
        super(source);
        this.name = name;
        this.tagsWithDuplicates = tags;
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        return actual;
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.NAME) {
            return this.name;
        }
        if (key == Scannable.Attr.TAGS && this.tagsWithDuplicates != null) {
            return this.tagsWithDuplicates.stream();
        }
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return super.scanUnsafe(key);
    }
}

