/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.core.publisher;

import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.core.CoreSubscriber;
import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.core.Exceptions;
import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.core.Fuseable;
import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.core.Scannable;
import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.core.publisher.Mono;
import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.core.publisher.Operators;
import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.core.publisher.SourceProducer;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Supplier;

final class MonoErrorSupplied<T>
extends Mono<T>
implements Fuseable.ScalarCallable<T>,
SourceProducer<T> {
    final Supplier<? extends Throwable> errorSupplier;

    MonoErrorSupplied(Supplier<? extends Throwable> errorSupplier) {
        this.errorSupplier = Objects.requireNonNull(errorSupplier, "errorSupplier");
    }

    @Override
    public T block(Duration m4) {
        Throwable error = Objects.requireNonNull(this.errorSupplier.get(), "the errorSupplier returned null");
        throw Exceptions.propagate(error);
    }

    @Override
    public T block() {
        Throwable error = Objects.requireNonNull(this.errorSupplier.get(), "the errorSupplier returned null");
        throw Exceptions.propagate(error);
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        Throwable error = Objects.requireNonNull(this.errorSupplier.get(), "the errorSupplier returned null");
        Operators.error(actual, error);
    }

    @Override
    public T call() throws Exception {
        Throwable error = Objects.requireNonNull(this.errorSupplier.get(), "the errorSupplier returned null");
        if (error instanceof Exception) {
            throw (Exception)error;
        }
        throw Exceptions.propagate(error);
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return null;
    }
}

