/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.core.publisher;

import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.core.CoreSubscriber;
import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.core.Fuseable;
import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.core.Scannable;
import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.core.publisher.Flux;
import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.core.publisher.MonoFromFluxOperator;
import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.core.publisher.Operators;
import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.util.annotation.Nullable;
import java.util.Objects;
import java.util.function.Predicate;

final class MonoAll<T>
extends MonoFromFluxOperator<T, Boolean>
implements Fuseable {
    final Predicate<? super T> predicate;

    MonoAll(Flux<? extends T> source, Predicate<? super T> predicate) {
        super(source);
        this.predicate = Objects.requireNonNull(predicate, "predicate");
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super Boolean> actual) {
        return new AllSubscriber<T>(actual, this.predicate);
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return super.scanUnsafe(key);
    }

    static final class AllSubscriber<T>
    extends Operators.BaseFluxToMonoOperator<T, Boolean> {
        final Predicate<? super T> predicate;
        boolean done;

        AllSubscriber(CoreSubscriber<? super Boolean> actual, Predicate<? super T> predicate) {
            super(actual);
            this.predicate = predicate;
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.TERMINATED) {
                return this.done;
            }
            return super.scanUnsafe(key);
        }

        @Override
        public void onNext(T t2) {
            boolean b;
            if (this.done) {
                Operators.onDiscard(t2, this.actual.currentContext());
                return;
            }
            try {
                b = this.predicate.test(t2);
            }
            catch (Throwable e) {
                this.done = true;
                this.actual.onError(Operators.onOperatorError(this.s, e, t2, this.actual.currentContext()));
                return;
            }
            if (!b) {
                this.done = true;
                this.s.cancel();
                this.actual.onNext(false);
                this.actual.onComplete();
            }
        }

        @Override
        public void onError(Throwable t2) {
            if (this.done) {
                Operators.onErrorDropped(t2, this.actual.currentContext());
                return;
            }
            this.done = true;
            this.actual.onError(t2);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.completePossiblyEmpty();
        }

        @Override
        Boolean accumulatedValue() {
            return true;
        }
    }
}

