/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.core.publisher;

import io.micrometer.context.ContextRegistry;
import io.micrometer.context.ContextSnapshot;
import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.core.observability.SignalListener;
import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.core.publisher.SignalType;
import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.core.publisher.SynchronousSink;
import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.util.Logger;
import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.util.Loggers;
import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.util.annotation.Nullable;
import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.util.context.Context;
import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.util.context.ContextView;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

final class ContextPropagation {
    static final Logger LOGGER;
    static final boolean isContextPropagationAvailable;
    static final Predicate<Object> PREDICATE_TRUE;
    static final Function<Context, Context> NO_OP;
    static final Function<Context, Context> WITH_GLOBAL_REGISTRY_NO_PREDICATE;

    ContextPropagation() {
    }

    static boolean isContextPropagationAvailable() {
        return isContextPropagationAvailable;
    }

    static Function<Context, Context> contextCapture() {
        if (!isContextPropagationAvailable) {
            return NO_OP;
        }
        return WITH_GLOBAL_REGISTRY_NO_PREDICATE;
    }

    static Function<Context, Context> contextCapture(Predicate<Object> captureKeyPredicate) {
        if (!isContextPropagationAvailable) {
            return NO_OP;
        }
        return target -> (Context)ContextSnapshot.captureAllUsing((Predicate)captureKeyPredicate, (ContextRegistry)ContextRegistry.getInstance(), (Object[])new Object[0]).updateContext(target);
    }

    static <T, R> BiConsumer<T, SynchronousSink<R>> contextRestoreForHandle(BiConsumer<T, SynchronousSink<R>> handler, Supplier<Context> contextSupplier) {
        if (!ContextPropagation.isContextPropagationAvailable()) {
            return handler;
        }
        Context ctx = contextSupplier.get();
        if (ctx.isEmpty()) {
            return handler;
        }
        return (v, sink) -> {
            try (ContextSnapshot.Scope ignored = ContextSnapshot.setAllThreadLocalsFrom((Object)ctx);){
                handler.accept((Object)v, (SynchronousSink)sink);
            }
        };
    }

    static <T> SignalListener<T> contextRestoreForTap(SignalListener<T> original, Supplier<Context> contextSupplier) {
        if (!ContextPropagation.isContextPropagationAvailable()) {
            return original;
        }
        Context ctx = contextSupplier.get();
        if (ctx.isEmpty()) {
            return original;
        }
        return new ContextRestoreSignalListener<T>(original, ctx, null);
    }

    static {
        boolean contextPropagation;
        Function<Context, Context> contextCaptureFunction;
        PREDICATE_TRUE = v -> true;
        NO_OP = c -> c;
        LOGGER = Loggers.getLogger(ContextPropagation.class);
        try {
            ContextRegistry globalRegistry = ContextRegistry.getInstance();
            contextCaptureFunction = target -> (Context)ContextSnapshot.captureAllUsing(PREDICATE_TRUE, (ContextRegistry)globalRegistry, (Object[])new Object[0]).updateContext(target);
            contextPropagation = true;
        }
        catch (LinkageError t2) {
            contextCaptureFunction = NO_OP;
            contextPropagation = false;
        }
        catch (Throwable t3) {
            contextCaptureFunction = NO_OP;
            contextPropagation = false;
            LOGGER.error("Unexpected exception while detecting ContextPropagation feature. The feature is considered disabled due to this:", t3);
        }
        isContextPropagationAvailable = contextPropagation;
        WITH_GLOBAL_REGISTRY_NO_PREDICATE = contextCaptureFunction;
    }

    static final class ContextRestoreSignalListener<T>
    implements SignalListener<T> {
        final SignalListener<T> original;
        final ContextView context;
        final ContextRegistry registry;

        public ContextRestoreSignalListener(SignalListener<T> original, ContextView context, @Nullable ContextRegistry registry) {
            this.original = original;
            this.context = context;
            this.registry = registry == null ? ContextRegistry.getInstance() : registry;
        }

        ContextSnapshot.Scope restoreThreadLocals() {
            return ContextSnapshot.setAllThreadLocalsFrom((Object)this.context, (ContextRegistry)this.registry);
        }

        @Override
        public void doFirst() throws Throwable {
            try (ContextSnapshot.Scope ignored = this.restoreThreadLocals();){
                this.original.doFirst();
            }
        }

        @Override
        public void doFinally(SignalType terminationType) throws Throwable {
            try (ContextSnapshot.Scope ignored = this.restoreThreadLocals();){
                this.original.doFinally(terminationType);
            }
        }

        @Override
        public void doOnSubscription() throws Throwable {
            try (ContextSnapshot.Scope ignored = this.restoreThreadLocals();){
                this.original.doOnSubscription();
            }
        }

        @Override
        public void doOnFusion(int negotiatedFusion) throws Throwable {
            try (ContextSnapshot.Scope ignored = this.restoreThreadLocals();){
                this.original.doOnFusion(negotiatedFusion);
            }
        }

        @Override
        public void doOnRequest(long requested) throws Throwable {
            try (ContextSnapshot.Scope ignored = this.restoreThreadLocals();){
                this.original.doOnRequest(requested);
            }
        }

        @Override
        public void doOnCancel() throws Throwable {
            try (ContextSnapshot.Scope ignored = this.restoreThreadLocals();){
                this.original.doOnCancel();
            }
        }

        @Override
        public void doOnNext(T value) throws Throwable {
            try (ContextSnapshot.Scope ignored = this.restoreThreadLocals();){
                this.original.doOnNext(value);
            }
        }

        @Override
        public void doOnComplete() throws Throwable {
            try (ContextSnapshot.Scope ignored = this.restoreThreadLocals();){
                this.original.doOnComplete();
            }
        }

        @Override
        public void doOnError(Throwable error) throws Throwable {
            try (ContextSnapshot.Scope ignored = this.restoreThreadLocals();){
                this.original.doOnError(error);
            }
        }

        @Override
        public void doAfterComplete() throws Throwable {
            try (ContextSnapshot.Scope ignored = this.restoreThreadLocals();){
                this.original.doAfterComplete();
            }
        }

        @Override
        public void doAfterError(Throwable error) throws Throwable {
            try (ContextSnapshot.Scope ignored = this.restoreThreadLocals();){
                this.original.doAfterError(error);
            }
        }

        @Override
        public void doOnMalformedOnNext(T value) throws Throwable {
            try (ContextSnapshot.Scope ignored = this.restoreThreadLocals();){
                this.original.doOnMalformedOnNext(value);
            }
        }

        @Override
        public void doOnMalformedOnError(Throwable error) throws Throwable {
            try (ContextSnapshot.Scope ignored = this.restoreThreadLocals();){
                this.original.doOnMalformedOnError(error);
            }
        }

        @Override
        public void doOnMalformedOnComplete() throws Throwable {
            try (ContextSnapshot.Scope ignored = this.restoreThreadLocals();){
                this.original.doOnMalformedOnComplete();
            }
        }

        @Override
        public void handleListenerError(Throwable listenerError) {
            try (ContextSnapshot.Scope ignored = this.restoreThreadLocals();){
                this.original.handleListenerError(listenerError);
            }
        }

        @Override
        public Context addToContext(Context originalContext) {
            try (ContextSnapshot.Scope ignored = this.restoreThreadLocals();){
                Context context = this.original.addToContext(originalContext);
                return context;
            }
        }
    }
}

