/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsarmetadatastoreoxia.shaded.net.openhft.hashing;

import io.streamnative.pulsarmetadatastoreoxia.shaded.net.openhft.hashing.MathsJDK9;
import org.jetbrains.annotations.NotNull;

class Maths {
    @NotNull
    private static final Maths INSTANCE;

    Maths() {
    }

    public static long unsignedLongMulXorFold(long lhs, long rhs) {
        return INSTANCE.unsignedLongMulXorFoldImp(lhs, rhs);
    }

    public static long unsignedLongMulHigh(long lhs, long rhs) {
        return INSTANCE.unsignedLongMulHighImp(lhs, rhs);
    }

    long unsignedLongMulXorFoldImp(long lhs, long rhs) {
        long lhs_l = lhs & 0xFFFFFFFFL;
        long lhs_h = lhs >>> 32;
        long rhs_l = rhs & 0xFFFFFFFFL;
        long rhs_h = rhs >>> 32;
        long lo_lo = lhs_l * rhs_l;
        long hi_lo = lhs_h * rhs_l;
        long lo_hi = lhs_l * rhs_h;
        long hi_hi = lhs_h * rhs_h;
        long cross = (lo_lo >>> 32) + (hi_lo & 0xFFFFFFFFL) + lo_hi;
        long upper = (hi_lo >>> 32) + (cross >>> 32) + hi_hi;
        long lower = cross << 32 | lo_lo & 0xFFFFFFFFL;
        return lower ^ upper;
    }

    long unsignedLongMulHighImp(long lhs, long rhs) {
        long lhs_l = lhs & 0xFFFFFFFFL;
        long lhs_h = lhs >>> 32;
        long rhs_l = rhs & 0xFFFFFFFFL;
        long rhs_h = rhs >>> 32;
        long lo_lo = lhs_l * rhs_l;
        long hi_lo = lhs_h * rhs_l;
        long lo_hi = lhs_l * rhs_h;
        long hi_hi = lhs_h * rhs_h;
        long cross = (lo_lo >>> 32) + (hi_lo & 0xFFFFFFFFL) + lo_hi;
        long upper = (hi_lo >>> 32) + (cross >>> 32) + hi_hi;
        return upper;
    }

    static {
        boolean hasMultiplyHigh = true;
        try {
            Math.multiplyHigh(0L, 0L);
        }
        catch (Throwable ignore) {
            hasMultiplyHigh = false;
        }
        INSTANCE = hasMultiplyHigh ? new MathsJDK9() : new Maths();
    }
}

