/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsarmetadatastoreoxia.shaded.io.grpc.internal;

import io.streamnative.pulsarmetadatastoreoxia.shaded.com.google.common.annotations.VisibleForTesting;
import io.streamnative.pulsarmetadatastoreoxia.shaded.com.google.common.base.Preconditions;
import io.streamnative.pulsarmetadatastoreoxia.shaded.com.google.common.util.concurrent.ListenableFuture;
import io.streamnative.pulsarmetadatastoreoxia.shaded.com.google.common.util.concurrent.SettableFuture;
import io.streamnative.pulsarmetadatastoreoxia.shaded.io.grpc.CallOptions;
import io.streamnative.pulsarmetadatastoreoxia.shaded.io.grpc.ClientStreamTracer;
import io.streamnative.pulsarmetadatastoreoxia.shaded.io.grpc.InternalChannelz;
import io.streamnative.pulsarmetadatastoreoxia.shaded.io.grpc.InternalLogId;
import io.streamnative.pulsarmetadatastoreoxia.shaded.io.grpc.Metadata;
import io.streamnative.pulsarmetadatastoreoxia.shaded.io.grpc.MethodDescriptor;
import io.streamnative.pulsarmetadatastoreoxia.shaded.io.grpc.Status;
import io.streamnative.pulsarmetadatastoreoxia.shaded.io.grpc.internal.ClientStream;
import io.streamnative.pulsarmetadatastoreoxia.shaded.io.grpc.internal.ClientStreamListener;
import io.streamnative.pulsarmetadatastoreoxia.shaded.io.grpc.internal.ClientTransport;
import io.streamnative.pulsarmetadatastoreoxia.shaded.io.grpc.internal.FailingClientStream;
import java.util.concurrent.Executor;

class FailingClientTransport
implements ClientTransport {
    @VisibleForTesting
    final Status error;
    private final ClientStreamListener.RpcProgress rpcProgress;

    FailingClientTransport(Status error, ClientStreamListener.RpcProgress rpcProgress) {
        Preconditions.checkArgument(!error.isOk(), "error must not be OK");
        this.error = error;
        this.rpcProgress = rpcProgress;
    }

    @Override
    public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions, ClientStreamTracer[] tracers) {
        return new FailingClientStream(this.error, this.rpcProgress, tracers);
    }

    @Override
    public void ping(final ClientTransport.PingCallback callback, Executor executor) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                callback.onFailure(FailingClientTransport.this.error.asException());
            }
        });
    }

    @Override
    public ListenableFuture<InternalChannelz.SocketStats> getStats() {
        SettableFuture<InternalChannelz.SocketStats> ret = SettableFuture.create();
        ret.set(null);
        return ret;
    }

    @Override
    public InternalLogId getLogId() {
        throw new UnsupportedOperationException("Not a real transport");
    }
}

