/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsarmetadatastoreoxia.shaded.com.salesforce.reactivegrpc.common;

import io.streamnative.pulsarmetadatastoreoxia.shaded.com.google.common.base.Preconditions;
import io.streamnative.pulsarmetadatastoreoxia.shaded.com.salesforce.reactivegrpc.common.AbstractUnimplementedQueue;
import io.streamnative.pulsarmetadatastoreoxia.shaded.com.salesforce.reactivegrpc.common.FusionModeAwareSubscription;
import io.streamnative.pulsarmetadatastoreoxia.shaded.io.grpc.Status;
import io.streamnative.pulsarmetadatastoreoxia.shaded.io.grpc.StatusException;
import io.streamnative.pulsarmetadatastoreoxia.shaded.io.grpc.StatusRuntimeException;
import io.streamnative.pulsarmetadatastoreoxia.shaded.io.grpc.stub.CallStreamObserver;
import io.streamnative.pulsarmetadatastoreoxia.shaded.org.reactivestreams.Subscriber;
import io.streamnative.pulsarmetadatastoreoxia.shaded.org.reactivestreams.Subscription;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public abstract class AbstractSubscriberAndProducer<T>
implements Subscriber<T>,
Runnable {
    private static final int NOT_FUSED = -1;
    private static final int NONE = 0;
    private static final int SYNC = 1;
    private static final int ASYNC = 2;
    private static final int ANY = 3;
    private static final int THREAD_BARRIER = 4;
    private static final Subscription CANCELLED_SUBSCRIPTION = new CancelledQueueSubscription();
    private Throwable throwable;
    private boolean done;
    private boolean isRequested;
    private int sourceMode = -1;
    private volatile Subscription subscription;
    private static final AtomicReferenceFieldUpdater<AbstractSubscriberAndProducer, Subscription> SUBSCRIPTION = AtomicReferenceFieldUpdater.newUpdater(AbstractSubscriberAndProducer.class, Subscription.class, "subscription");
    protected volatile CallStreamObserver<T> downstream;
    private static final AtomicReferenceFieldUpdater<AbstractSubscriberAndProducer, CallStreamObserver> DOWNSTREAM = AtomicReferenceFieldUpdater.newUpdater(AbstractSubscriberAndProducer.class, CallStreamObserver.class, "downstream");
    private volatile int wip;
    private static final AtomicIntegerFieldUpdater<AbstractSubscriberAndProducer> WIP = AtomicIntegerFieldUpdater.newUpdater(AbstractSubscriberAndProducer.class, "wip");

    public void subscribe(CallStreamObserver<T> downstream) {
        Preconditions.checkNotNull(downstream);
        if (this.downstream == null && DOWNSTREAM.compareAndSet(this, null, downstream)) {
            downstream.setOnReadyHandler(this);
            return;
        }
        throw new IllegalStateException(this.getClass().getSimpleName() + " does not support multiple subscribers");
    }

    @Override
    public void run() {
        Subscription s2 = this.subscription;
        if (s2 != null && s2 != CANCELLED_SUBSCRIPTION) {
            this.drain();
        }
    }

    public void cancel() {
        Subscription s2 = SUBSCRIPTION.getAndSet(this, CANCELLED_SUBSCRIPTION);
        if (s2 != null && s2 != CANCELLED_SUBSCRIPTION) {
            s2.cancel();
            if (WIP.getAndIncrement(this) == 0 && this.sourceMode != 0) {
                ((Queue)((Object)s2)).clear();
            }
        }
    }

    public boolean isCanceled() {
        return this.subscription == CANCELLED_SUBSCRIPTION;
    }

    @Override
    public void onSubscribe(Subscription subscription) {
        Preconditions.checkNotNull(subscription);
        subscription = this.fuse(subscription);
        if (this.subscription == null && SUBSCRIPTION.compareAndSet(this, null, subscription)) {
            this.drain();
            return;
        }
        subscription.cancel();
    }

    @Override
    public void onNext(T t2) {
        if (this.sourceMode == 2 || this.sourceMode == -1) {
            this.drain();
            return;
        }
        if (!this.isCanceled()) {
            Preconditions.checkNotNull(t2);
            CallStreamObserver<T> subscriber = this.downstream;
            try {
                subscriber.onNext(t2);
                this.isRequested = false;
                this.drain();
            }
            catch (Throwable throwable) {
                this.cancel();
                try {
                    subscriber.onError(this.prepareError(throwable));
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void onError(Throwable t2) {
        if (!this.isCanceled()) {
            Preconditions.checkNotNull(t2);
            this.done = true;
            this.throwable = t2;
            this.drain();
        }
    }

    @Override
    public void onComplete() {
        if (!this.isCanceled()) {
            this.done = true;
            this.drain();
        }
    }

    protected abstract Subscription fuse(Subscription var1);

    private void drain() {
        if (WIP.getAndIncrement(this) != 0) {
            return;
        }
        int mode = this.sourceMode;
        int missed = 1;
        CallStreamObserver<T> subscriber = this.downstream;
        if (mode == -1) {
            Subscription s2 = this.subscription;
            if (s2 instanceof FusionModeAwareSubscription) {
                this.sourceMode = mode = ((FusionModeAwareSubscription)s2).mode();
                if (mode == 1) {
                    this.done = true;
                } else {
                    s2.request(1L);
                }
            } else {
                this.sourceMode = mode = 0;
            }
        }
        do {
            if (subscriber == null) continue;
            if (mode == 1) {
                this.drainSync();
            } else if (mode == 2) {
                this.drainAsync();
            } else {
                this.drainRegular();
            }
            return;
        } while ((missed = WIP.addAndGet(this, -missed)) != 0);
    }

    private void drainSync() {
        int missed = 1;
        CallStreamObserver<T> subscriber = this.downstream;
        Queue q = (Queue)((Object)this.subscription);
        while (true) {
            if (subscriber.isReady()) {
                Object v;
                try {
                    v = q.poll();
                }
                catch (Throwable ex) {
                    this.cancel();
                    q.clear();
                    try {
                        subscriber.onError(this.prepareError(ex));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return;
                }
                if (this.isCanceled()) {
                    q.clear();
                    return;
                }
                if (v == null) {
                    try {
                        subscriber.onCompleted();
                    }
                    catch (Throwable ex) {
                        // empty catch block
                    }
                    return;
                }
                try {
                    subscriber.onNext(v);
                }
                catch (Throwable ex) {
                    this.cancel();
                    q.clear();
                    try {
                        subscriber.onError(this.prepareError(ex));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return;
                }
            }
            if (this.isCanceled()) {
                q.clear();
                return;
            }
            if (q.isEmpty()) {
                try {
                    subscriber.onCompleted();
                }
                catch (Throwable v) {
                    // empty catch block
                }
                return;
            }
            int w = this.wip;
            if (missed == w) {
                if ((missed = WIP.addAndGet(this, -missed)) != 0) continue;
                break;
            }
            missed = w;
        }
    }

    private void drainAsync() {
        int missed = 1;
        CallStreamObserver<T> subscriber = this.downstream;
        Subscription s2 = this.subscription;
        Queue q = (Queue)((Object)this.subscription);
        long sent = 0L;
        while (true) {
            if (subscriber.isReady()) {
                boolean empty;
                Object v;
                boolean d = this.done;
                try {
                    v = q.poll();
                }
                catch (Throwable ex) {
                    this.cancel();
                    q.clear();
                    try {
                        subscriber.onError(this.prepareError(ex));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return;
                }
                boolean bl = empty = v == null;
                if (this.checkTerminated(d, empty, subscriber, q)) {
                    return;
                }
                if (!empty) {
                    try {
                        subscriber.onNext(v);
                    }
                    catch (Throwable ex) {
                        this.cancel();
                        q.clear();
                        try {
                            subscriber.onError(this.prepareError(ex));
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        return;
                    }
                    ++sent;
                    continue;
                }
            }
            if (this.checkTerminated(this.done, q.isEmpty(), subscriber, q)) {
                return;
            }
            int w = this.wip;
            if (missed == w) {
                if (sent > 0L) {
                    s2.request(sent);
                }
                if ((missed = WIP.addAndGet(this, -missed)) == 0) break;
                sent = 0L;
                continue;
            }
            missed = w;
        }
    }

    private void drainRegular() {
        int missed = 1;
        CallStreamObserver<T> a = this.downstream;
        while (true) {
            int w;
            if (this.done) {
                Throwable t2 = this.throwable;
                if (t2 != null) {
                    try {
                        a.onError(this.prepareError(t2));
                    }
                    catch (Throwable throwable) {}
                } else {
                    try {
                        a.onCompleted();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return;
            }
            if (a.isReady() && !this.isRequested) {
                this.isRequested = true;
                this.subscription.request(1L);
            }
            if (missed == (w = this.wip)) {
                if ((missed = WIP.addAndGet(this, -missed)) != 0) continue;
                break;
            }
            missed = w;
        }
    }

    private boolean checkTerminated(boolean d, boolean empty, CallStreamObserver<?> a, Queue<T> q) {
        if (this.isCanceled()) {
            q.clear();
            return true;
        }
        if (d) {
            Throwable t2 = this.throwable;
            if (t2 != null) {
                q.clear();
                try {
                    a.onError(this.prepareError(t2));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return true;
            }
            if (empty) {
                try {
                    a.onCompleted();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return true;
            }
        }
        return false;
    }

    protected Throwable prepareError(Throwable throwable) {
        if (throwable instanceof StatusException || throwable instanceof StatusRuntimeException) {
            return throwable;
        }
        return Status.fromThrowable(throwable).asException();
    }

    private static class CancelledQueueSubscription
    extends AbstractUnimplementedQueue<Object>
    implements Subscription {
        private CancelledQueueSubscription() {
        }

        @Override
        public void cancel() {
        }

        @Override
        public void request(long n) {
        }

        @Override
        public Object poll() {
            return null;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public void clear() {
        }
    }
}

