/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client.session;

import io.streamnative.oxia.client.ClientConfig;
import io.streamnative.oxia.client.metrics.SessionMetrics;
import io.streamnative.oxia.client.session.Session;
import io.streamnative.oxia.client.shard.ShardManager;
import io.streamnative.oxia.proto.ReactorOxiaClientGrpc;
import io.streamnative.pulsarmetadatastoreoxia.shaded.com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionManager
implements AutoCloseable,
Consumer<ShardManager.ShardAssignmentChanges> {
    private static final Logger log = LoggerFactory.getLogger(SessionManager.class);
    private final ConcurrentMap<Long, Session> sessionsByShardId = new ConcurrentHashMap<Long, Session>();
    @NonNull
    private final Session.Factory factory;
    private volatile boolean closed = false;

    public SessionManager(@NonNull ClientConfig config, @NonNull Function<Long, ReactorOxiaClientGrpc.ReactorOxiaClientStub> stubByShardId) {
        this(new Session.Factory(config, stubByShardId, SessionMetrics.create(config.metrics())));
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (stubByShardId == null) {
            throw new NullPointerException("stubByShardId is marked non-null but is null");
        }
    }

    @NonNull
    public Session getSession(long shardId) {
        if (this.closed) {
            throw new IllegalStateException("session manager has been closed");
        }
        return this.sessionsByShardId.computeIfAbsent(shardId, s2 -> {
            Session session = this.factory.create(shardId);
            session.start();
            return session;
        });
    }

    @Override
    public void close() throws Exception {
        if (this.closed) {
            return;
        }
        this.closed = true;
        ArrayList<Session> closedSessions = new ArrayList<Session>();
        this.sessionsByShardId.entrySet().parallelStream().forEach(entry -> this.closeQuietly((Session)entry.getValue()).ifPresent(closedSessions::add));
        closedSessions.forEach(s2 -> this.sessionsByShardId.remove(s2.getSessionId()));
    }

    @VisibleForTesting
    Map<Long, Session> sessions() {
        return Collections.unmodifiableMap(new HashMap<Long, Session>(this.sessionsByShardId));
    }

    @Override
    public void accept(@NonNull ShardManager.ShardAssignmentChanges changes) {
        if (changes == null) {
            throw new NullPointerException("changes is marked non-null but is null");
        }
        if (!this.closed) {
            Set<ShardManager.ShardAssignmentChange.Removed> removed = changes.removed();
            removed.forEach(s2 -> this.closeQuietly((Session)this.sessionsByShardId.remove(s2.shardId())));
            Set<ShardManager.ShardAssignmentChange.Reassigned> reassigned = changes.reassigned();
            reassigned.forEach(s2 -> this.closeQuietly((Session)this.sessionsByShardId.remove(s2.shardId())).ifPresent(c -> this.getSession(s2.shardId())));
        }
    }

    @VisibleForTesting
    Optional<Session> closeQuietly(Session session) {
        if (session != null) {
            try {
                session.close();
            }
            catch (Exception e) {
                log.warn("Error closing session {}", (Object)session.getSessionId(), (Object)e);
            }
        }
        return Optional.ofNullable(session);
    }

    SessionManager(@NonNull Session.Factory factory) {
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        this.factory = factory;
    }
}

