/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client.metrics;

import io.streamnative.oxia.client.api.GetResult;
import io.streamnative.oxia.client.api.PutResult;
import io.streamnative.oxia.client.metrics.api.Metrics;
import java.time.Clock;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

public class OperationMetrics {
    private final Clock clock;
    private final Metrics.Histogram timer;
    private final Metrics.Histogram size;

    public static OperationMetrics create(Clock clock, Metrics metrics) {
        Metrics.Histogram timer = metrics.histogram("oxia_client_operation_timer", Metrics.Unit.MILLISECONDS);
        Metrics.Histogram size = metrics.histogram("oxia_client_operation_size", Metrics.Unit.BYTES);
        return new OperationMetrics(clock, timer, size);
    }

    public Sample<PutResult> recordPut(long valueSize) {
        return this.record("put", (t2, attributes) -> this.size.record(valueSize, (Map<String, String>)attributes));
    }

    public Sample<Boolean> recordDelete() {
        return this.record("delete");
    }

    public Sample<Void> recordDeleteRange() {
        return this.record("delete_range");
    }

    public Sample<GetResult> recordGet() {
        return this.record("get", (r, attributes) -> {
            int valueSize = 0;
            if (r != null) {
                valueSize = r.getValue().length;
            }
            this.size.record(valueSize, (Map<String, String>)attributes);
        });
    }

    public Sample<List<String>> recordList() {
        return this.record("list");
    }

    private <R> Sample<R> record(String type) {
        return this.record(type, (t2, attributes) -> {});
    }

    private <R> Sample<R> record(String type, BiConsumer<R, Map<String, String>> consumer) {
        long start = this.clock.millis();
        return (r, t2) -> {
            Map<String, String> attributes = Metrics.attributes(type, t2);
            this.timer.record(this.clock.millis() - start, attributes);
            consumer.accept(r, attributes);
        };
    }

    OperationMetrics(Clock clock, Metrics.Histogram timer, Metrics.Histogram size) {
        this.clock = clock;
        this.timer = timer;
        this.size = size;
    }

    public static interface Sample<R> {
        public void stop(R var1, Throwable var2);
    }
}

