/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client.metrics;

import io.streamnative.oxia.client.metrics.api.Metrics;
import io.streamnative.oxia.proto.Notification;
import io.streamnative.oxia.proto.NotificationBatch;
import io.streamnative.pulsarmetadatastoreoxia.shaded.com.google.common.annotations.VisibleForTesting;
import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.core.publisher.Signal;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;

public class NotificationMetrics {
    @NonNull
    private final Metrics.Histogram batch;
    @NonNull
    private final Metrics.Histogram event;

    @NonNull
    public static NotificationMetrics create(@NonNull Metrics metrics) {
        if (metrics == null) {
            throw new NullPointerException("metrics is marked non-null but is null");
        }
        Metrics.Histogram batch = metrics.histogram("oxia_client_notification", Metrics.Unit.NONE);
        Metrics.Histogram events = metrics.histogram("oxia_client_notification_event", Metrics.Unit.NONE);
        return new NotificationMetrics(batch, events);
    }

    public void recordBatch(@NonNull Signal<NotificationBatch> signal) {
        if (signal == null) {
            throw new NullPointerException("signal is marked non-null but is null");
        }
        String type = "batch";
        switch (signal.getType()) {
            case ON_NEXT: {
                this.batch.record(1L, Metrics.attributes(type, true));
                this.recordNotification(signal.get());
                break;
            }
            case ON_ERROR: {
                this.batch.record(1L, Metrics.attributes(type, false));
                break;
            }
        }
    }

    @VisibleForTesting
    void recordNotification(@NonNull NotificationBatch batch) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        batch.getNotificationsMap().values().stream().collect(Collectors.groupingBy(Notification::getType)).forEach((key, value) -> {
            Map<String, String> attributes = Map.of("type", key.name().toLowerCase());
            this.event.record(value.size(), attributes);
        });
    }

    NotificationMetrics(@NonNull Metrics.Histogram batch, @NonNull Metrics.Histogram event) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.batch = batch;
        this.event = event;
    }
}

