/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client.grpc;

import io.streamnative.oxia.client.grpc.ServiceAddress;
import io.streamnative.oxia.proto.ReactorOxiaClientGrpc;
import io.streamnative.pulsarmetadatastoreoxia.shaded.io.grpc.Channel;
import io.streamnative.pulsarmetadatastoreoxia.shaded.io.grpc.ManagedChannel;
import io.streamnative.pulsarmetadatastoreoxia.shaded.io.grpc.ManagedChannelBuilder;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import lombok.NonNull;

public class ChannelManager
implements Function<String, Channel>,
AutoCloseable {
    private final ConcurrentMap<String, ManagedChannel> channels = new ConcurrentHashMap<String, ManagedChannel>();
    @NonNull
    private final StubFactory<ReactorOxiaClientGrpc.ReactorOxiaClientStub> reactorStubFactory;
    private volatile boolean closed;

    public ChannelManager() {
        this.reactorStubFactory = ChannelManager.reactorStubFactory(this);
    }

    @Override
    public void close() throws Exception {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.channels.values().forEach(this::shutdown);
    }

    private void shutdown(ManagedChannel channel) {
        channel.shutdown();
        try {
            if (!channel.awaitTermination(100L, TimeUnit.MILLISECONDS)) {
                channel.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            channel.shutdownNow();
        }
    }

    @Override
    @NonNull
    public Channel apply(@NonNull String address) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        if (this.closed) {
            throw new IllegalStateException("Channel manager is closed");
        }
        ServiceAddress serviceAddress = new ServiceAddress(address);
        return this.channels.computeIfAbsent(address, a -> ((ManagedChannelBuilder)ManagedChannelBuilder.forAddress(serviceAddress.host(), serviceAddress.port()).usePlaintext()).build());
    }

    static StubFactory<ReactorOxiaClientGrpc.ReactorOxiaClientStub> reactorStubFactory(@NonNull ChannelManager channelManager) {
        if (channelManager == null) {
            throw new NullPointerException("channelManager is marked non-null but is null");
        }
        return new StubFactory<ReactorOxiaClientGrpc.ReactorOxiaClientStub>(channelManager, ReactorOxiaClientGrpc::newReactorStub);
    }

    public ChannelManager(@NonNull StubFactory<ReactorOxiaClientGrpc.ReactorOxiaClientStub> reactorStubFactory) {
        if (reactorStubFactory == null) {
            throw new NullPointerException("io.streamnative.pulsarmetadatastoreoxia.shaded.reactorStubFactory is marked non-null but is null");
        }
        this.reactorStubFactory = reactorStubFactory;
    }

    @NonNull
    public StubFactory<ReactorOxiaClientGrpc.ReactorOxiaClientStub> getReactorStubFactory() {
        return this.reactorStubFactory;
    }

    public static class StubFactory<T>
    implements Function<String, T> {
        private final Function<String, T> addressToStubFn;
        private final ConcurrentMap<String, T> stubs = new ConcurrentHashMap<String, T>();

        StubFactory(@NonNull ChannelManager channelManager, @NonNull Function<Channel, T> channelToStubFn) {
            if (channelManager == null) {
                throw new NullPointerException("channelManager is marked non-null but is null");
            }
            if (channelToStubFn == null) {
                throw new NullPointerException("channelToStubFn is marked non-null but is null");
            }
            this.addressToStubFn = channelManager.andThen(channelToStubFn);
        }

        @Override
        public T apply(String address) {
            return this.stubs.computeIfAbsent(address, this.addressToStubFn);
        }
    }
}

