/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client.batch;

import io.streamnative.oxia.client.ClientConfig;
import io.streamnative.oxia.client.batch.Batch;
import io.streamnative.oxia.client.batch.Operation;
import io.streamnative.oxia.client.metrics.BatchMetrics;
import io.streamnative.oxia.client.session.SessionManager;
import io.streamnative.oxia.proto.ReactorOxiaClientGrpc;
import java.time.Clock;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import lombok.NonNull;

public class Batcher
implements Runnable,
AutoCloseable {
    private static final int DEFAULT_INITIAL_QUEUE_CAPACITY = 1000;
    @NonNull
    private final ClientConfig config;
    private final long shardId;
    @NonNull
    private final Function<Long, Batch> batchFactory;
    @NonNull
    private final BlockingQueue<Operation<?>> operations;
    @NonNull
    private final Clock clock;

    Batcher(@NonNull ClientConfig config, long shardId, @NonNull Function<Long, Batch> batchFactory) {
        this(config, shardId, batchFactory, new PriorityBlockingQueue(1000, Operation.PriorityComparator), Clock.systemUTC());
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (batchFactory == null) {
            throw new NullPointerException("batchFactory is marked non-null but is null");
        }
    }

    public <R> void add(@NonNull Operation<R> operation) {
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        try {
            this.operations.put(operation);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void run() {
        Batch batch = null;
        long lingerBudgetMs = -1L;
        try {
            while (true) {
                Operation<?> operation = null;
                if (batch == null) {
                    operation = this.operations.take();
                } else {
                    operation = this.operations.poll(lingerBudgetMs, TimeUnit.MILLISECONDS);
                    long spentLingerBudgetMs = Math.max(0L, this.clock.millis() - batch.getStartTime());
                    lingerBudgetMs = Math.max(0L, lingerBudgetMs - spentLingerBudgetMs);
                }
                if (operation == Operation.CloseOperation.INSTANCE) break;
                if (operation != null) {
                    if (batch == null) {
                        batch = this.batchFactory.apply(this.shardId);
                        lingerBudgetMs = this.config.batchLinger().toMillis();
                    }
                    try {
                        if (!batch.canAdd(operation)) {
                            batch.complete();
                            batch = this.batchFactory.apply(this.shardId);
                            lingerBudgetMs = this.config.batchLinger().toMillis();
                        }
                        batch.add(operation);
                    }
                    catch (Exception e) {
                        operation.fail(e);
                    }
                }
                if (batch == null || batch.size() != this.config.maxRequestsPerBatch() && lingerBudgetMs != 0L) continue;
                batch.complete();
                batch = null;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    @NonNull
    static Function<Long, Batcher> newReadBatcherFactory(@NonNull ClientConfig config, @NonNull Function<Long, ReactorOxiaClientGrpc.ReactorOxiaClientStub> stubByShardId, Clock clock, BatchMetrics metrics) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (stubByShardId == null) {
            throw new NullPointerException("stubByShardId is marked non-null but is null");
        }
        return s2 -> new Batcher(config, (long)s2, new Batch.ReadBatchFactory(stubByShardId, config, clock, metrics));
    }

    @NonNull
    static Function<Long, Batcher> newWriteBatcherFactory(@NonNull ClientConfig config, @NonNull Function<Long, ReactorOxiaClientGrpc.ReactorOxiaClientStub> stubByShardId, @NonNull SessionManager sessionManager, Clock clock, BatchMetrics metrics) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (stubByShardId == null) {
            throw new NullPointerException("stubByShardId is marked non-null but is null");
        }
        if (sessionManager == null) {
            throw new NullPointerException("sessionManager is marked non-null but is null");
        }
        return s2 -> new Batcher(config, (long)s2, new Batch.WriteBatchFactory(stubByShardId, sessionManager, config, clock, metrics));
    }

    @Override
    public void close() throws Exception {
        this.operations.add(Operation.CloseOperation.INSTANCE);
    }

    Batcher(@NonNull ClientConfig config, long shardId, @NonNull Function<Long, Batch> batchFactory, @NonNull BlockingQueue<Operation<?>> operations, @NonNull Clock clock) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (batchFactory == null) {
            throw new NullPointerException("batchFactory is marked non-null but is null");
        }
        if (operations == null) {
            throw new NullPointerException("operations is marked non-null but is null");
        }
        if (clock == null) {
            throw new NullPointerException("clock is marked non-null but is null");
        }
        this.config = config;
        this.shardId = shardId;
        this.batchFactory = batchFactory;
        this.operations = operations;
        this.clock = clock;
    }
}

