/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client.batch;

import io.streamnative.oxia.client.ClientConfig;
import io.streamnative.oxia.client.batch.Operation;
import io.streamnative.oxia.client.metrics.BatchMetrics;
import io.streamnative.oxia.client.session.SessionManager;
import io.streamnative.oxia.proto.GetResponse;
import io.streamnative.oxia.proto.ReactorOxiaClientGrpc;
import io.streamnative.oxia.proto.ReadRequest;
import io.streamnative.oxia.proto.WriteRequest;
import io.streamnative.oxia.proto.WriteResponse;
import io.streamnative.pulsarmetadatastoreoxia.shaded.com.google.common.annotations.VisibleForTesting;
import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.core.publisher.Flux;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;

public interface Batch {
    public long getStartTime();

    public void add(@NonNull Operation<?> var1);

    public boolean canAdd(@NonNull Operation<?> var1);

    public int size();

    public long getShardId();

    public void complete();

    public static class ReadBatchFactory
    extends BatchFactory {
        public ReadBatchFactory(@NonNull Function<Long, ReactorOxiaClientGrpc.ReactorOxiaClientStub> stubByShardId, @NonNull ClientConfig config, @NonNull Clock clock, @NonNull BatchMetrics metrics) {
            super(stubByShardId, config, clock, metrics);
            if (stubByShardId == null) {
                throw new NullPointerException("stubByShardId is marked non-null but is null");
            }
            if (config == null) {
                throw new NullPointerException("config is marked non-null but is null");
            }
            if (clock == null) {
                throw new NullPointerException("clock is marked non-null but is null");
            }
            if (metrics == null) {
                throw new NullPointerException("metrics is marked non-null but is null");
            }
        }

        @Override
        @NonNull
        public Batch apply(@NonNull Long shardId) {
            if (shardId == null) {
                throw new NullPointerException("shardId is marked non-null but is null");
            }
            return new ReadBatch(this.stubByShardId, shardId, this.clock.millis(), this.metrics.recordRead());
        }
    }

    public static class WriteBatchFactory
    extends BatchFactory {
        @NonNull
        final SessionManager sessionManager;

        public WriteBatchFactory(@NonNull Function<Long, ReactorOxiaClientGrpc.ReactorOxiaClientStub> stubByShardId, @NonNull SessionManager sessionManager, @NonNull ClientConfig config, @NonNull Clock clock, @NonNull BatchMetrics metrics) {
            super(stubByShardId, config, clock, metrics);
            if (stubByShardId == null) {
                throw new NullPointerException("stubByShardId is marked non-null but is null");
            }
            if (sessionManager == null) {
                throw new NullPointerException("sessionManager is marked non-null but is null");
            }
            if (config == null) {
                throw new NullPointerException("config is marked non-null but is null");
            }
            if (clock == null) {
                throw new NullPointerException("clock is marked non-null but is null");
            }
            if (metrics == null) {
                throw new NullPointerException("metrics is marked non-null but is null");
            }
            this.sessionManager = sessionManager;
        }

        @Override
        @NonNull
        public Batch apply(@NonNull Long shardId) {
            if (shardId == null) {
                throw new NullPointerException("shardId is marked non-null but is null");
            }
            return new WriteBatch(this.stubByShardId, this.sessionManager, this.getConfig().clientIdentifier(), shardId, this.clock.millis(), this.getConfig().maxBatchSize(), this.metrics.recordWrite());
        }
    }

    public static abstract class BatchFactory
    implements Function<Long, Batch> {
        @NonNull
        final Function<Long, ReactorOxiaClientGrpc.ReactorOxiaClientStub> stubByShardId;
        @NonNull
        private final ClientConfig config;
        @NonNull
        final Clock clock;
        @NonNull
        final BatchMetrics metrics;

        @Override
        @NonNull
        public abstract Batch apply(@NonNull Long var1);

        BatchFactory(@NonNull Function<Long, ReactorOxiaClientGrpc.ReactorOxiaClientStub> stubByShardId, @NonNull ClientConfig config, @NonNull Clock clock, @NonNull BatchMetrics metrics) {
            if (stubByShardId == null) {
                throw new NullPointerException("stubByShardId is marked non-null but is null");
            }
            if (config == null) {
                throw new NullPointerException("config is marked non-null but is null");
            }
            if (clock == null) {
                throw new NullPointerException("clock is marked non-null but is null");
            }
            if (metrics == null) {
                throw new NullPointerException("metrics is marked non-null but is null");
            }
            this.stubByShardId = stubByShardId;
            this.config = config;
            this.clock = clock;
            this.metrics = metrics;
        }

        @NonNull
        ClientConfig getConfig() {
            return this.config;
        }
    }

    public static abstract class BatchBase {
        @NonNull
        private final Function<Long, ReactorOxiaClientGrpc.ReactorOxiaClientStub> stubByShardId;
        private final long shardId;
        private final long startTime;
        final BatchMetrics.Sample sample;

        protected ReactorOxiaClientGrpc.ReactorOxiaClientStub getStub() {
            return this.stubByShardId.apply(this.shardId);
        }

        private BatchBase(@NonNull Function<Long, ReactorOxiaClientGrpc.ReactorOxiaClientStub> stubByShardId, long shardId, long startTime, BatchMetrics.Sample sample) {
            if (stubByShardId == null) {
                throw new NullPointerException("stubByShardId is marked non-null but is null");
            }
            this.stubByShardId = stubByShardId;
            this.shardId = shardId;
            this.startTime = startTime;
            this.sample = sample;
        }

        public long getShardId() {
            return this.shardId;
        }

        public long getStartTime() {
            return this.startTime;
        }
    }

    public static final class ReadBatch
    extends BatchBase
    implements Batch {
        @VisibleForTesting
        final List<Operation.ReadOperation.GetOperation> gets = new ArrayList<Operation.ReadOperation.GetOperation>();

        @Override
        public boolean canAdd(@NonNull Operation<?> operation) {
            if (operation == null) {
                throw new NullPointerException("operation is marked non-null but is null");
            }
            return true;
        }

        @Override
        public void add(@NonNull Operation<?> operation) {
            if (operation == null) {
                throw new NullPointerException("operation is marked non-null but is null");
            }
            if (operation instanceof Operation.ReadOperation.GetOperation) {
                Operation.ReadOperation.GetOperation g2 = (Operation.ReadOperation.GetOperation)operation;
                this.gets.add(g2);
            }
        }

        ReadBatch(@NonNull Function<Long, ReactorOxiaClientGrpc.ReactorOxiaClientStub> stubByShardId, long shardId, long createTime, BatchMetrics.Sample sample) {
            super(stubByShardId, shardId, createTime, sample);
            if (stubByShardId == null) {
                throw new NullPointerException("stubByShardId is marked non-null but is null");
            }
        }

        @Override
        public int size() {
            return this.gets.size();
        }

        @Override
        public void complete() {
            this.sample.startExec();
            Throwable t2 = null;
            LongAdder bytes = new LongAdder();
            try {
                Flux<GetResponse> responses = this.getStub().read(this.toProto()).flatMapSequential(response -> Flux.fromIterable(response.getGetsList())).doOnNext(r -> bytes.add(r.getValue().size()));
                Flux.fromIterable(this.gets).zipWith(responses, this::complete).then().block();
            }
            catch (Throwable batchError) {
                t2 = batchError;
                this.gets.forEach(g2 -> g2.fail(batchError));
            }
            this.sample.stop(t2, bytes.sum(), this.size());
        }

        private boolean complete(Operation.ReadOperation.GetOperation operation, GetResponse response) {
            operation.complete(response);
            return true;
        }

        @NonNull
        ReadRequest toProto() {
            return ReadRequest.newBuilder().setShardId(this.getShardId()).addAllGets(this.gets.stream().map(Operation.ReadOperation.GetOperation::toProto).collect(Collectors.toList())).build();
        }
    }

    public static final class WriteBatch
    extends BatchBase
    implements Batch {
        @VisibleForTesting
        final List<Operation.WriteOperation.PutOperation> puts = new ArrayList<Operation.WriteOperation.PutOperation>();
        @VisibleForTesting
        final List<Operation.WriteOperation.DeleteOperation> deletes = new ArrayList<Operation.WriteOperation.DeleteOperation>();
        @VisibleForTesting
        final List<Operation.WriteOperation.DeleteRangeOperation> deleteRanges = new ArrayList<Operation.WriteOperation.DeleteRangeOperation>();
        private final SessionManager sessionManager;
        private final String clientIdentifier;
        private final int maxBatchSize;
        private boolean containsEphemeral;
        private int byteSize;
        private long bytes;

        WriteBatch(@NonNull Function<Long, ReactorOxiaClientGrpc.ReactorOxiaClientStub> stubByShardId, @NonNull SessionManager sessionManager, @NonNull String clientIdentifier, long shardId, long createTime, int maxBatchSize, BatchMetrics.Sample sample) {
            super(stubByShardId, shardId, createTime, sample);
            if (stubByShardId == null) {
                throw new NullPointerException("stubByShardId is marked non-null but is null");
            }
            if (sessionManager == null) {
                throw new NullPointerException("sessionManager is marked non-null but is null");
            }
            if (clientIdentifier == null) {
                throw new NullPointerException("clientIdentifier is marked non-null but is null");
            }
            this.sessionManager = sessionManager;
            this.clientIdentifier = clientIdentifier;
            this.byteSize = 0;
            this.maxBatchSize = maxBatchSize;
        }

        int sizeOf(@NonNull Operation<?> operation) {
            if (operation == null) {
                throw new NullPointerException("operation is marked non-null but is null");
            }
            if (operation instanceof Operation.WriteOperation.PutOperation) {
                Operation.WriteOperation.PutOperation p = (Operation.WriteOperation.PutOperation)operation;
                return p.key().getBytes(StandardCharsets.UTF_8).length + p.value().length;
            }
            if (operation instanceof Operation.WriteOperation.DeleteOperation) {
                Operation.WriteOperation.DeleteOperation d = (Operation.WriteOperation.DeleteOperation)operation;
                return d.key().getBytes(StandardCharsets.UTF_8).length;
            }
            if (operation instanceof Operation.WriteOperation.DeleteRangeOperation) {
                Operation.WriteOperation.DeleteRangeOperation r = (Operation.WriteOperation.DeleteRangeOperation)operation;
                return r.startKeyInclusive().getBytes(StandardCharsets.UTF_8).length + r.endKeyExclusive().getBytes(StandardCharsets.UTF_8).length;
            }
            return 0;
        }

        @Override
        public void add(@NonNull Operation<?> operation) {
            if (operation == null) {
                throw new NullPointerException("operation is marked non-null but is null");
            }
            if (operation instanceof Operation.WriteOperation.PutOperation) {
                Operation.WriteOperation.PutOperation p = (Operation.WriteOperation.PutOperation)operation;
                this.puts.add(p);
                this.bytes += (long)p.value().length;
                this.containsEphemeral |= p.ephemeral();
            } else if (operation instanceof Operation.WriteOperation.DeleteOperation) {
                Operation.WriteOperation.DeleteOperation d = (Operation.WriteOperation.DeleteOperation)operation;
                this.deletes.add(d);
            } else if (operation instanceof Operation.WriteOperation.DeleteRangeOperation) {
                Operation.WriteOperation.DeleteRangeOperation r = (Operation.WriteOperation.DeleteRangeOperation)operation;
                this.deleteRanges.add(r);
            }
            this.byteSize += this.sizeOf(operation);
        }

        @Override
        public boolean canAdd(@NonNull Operation<?> operation) {
            if (operation == null) {
                throw new NullPointerException("operation is marked non-null but is null");
            }
            int size = this.sizeOf(operation);
            return this.byteSize + size <= this.maxBatchSize;
        }

        @Override
        public int size() {
            return this.puts.size() + this.deletes.size() + this.deleteRanges.size();
        }

        @Override
        public void complete() {
            this.sample.startExec();
            Throwable t2 = null;
            try {
                int i;
                WriteResponse response = this.getStub().write(this.toProto()).block();
                for (i = 0; i < this.deletes.size(); ++i) {
                    this.deletes.get(i).complete(response.getDeletes(i));
                }
                for (i = 0; i < this.deleteRanges.size(); ++i) {
                    this.deleteRanges.get(i).complete(response.getDeleteRanges(i));
                }
                for (i = 0; i < this.puts.size(); ++i) {
                    this.puts.get(i).complete(response.getPuts(i));
                }
            }
            catch (Throwable batchError) {
                t2 = batchError;
                this.deletes.forEach(d -> d.fail(batchError));
                this.deleteRanges.forEach(f -> f.fail(batchError));
                this.puts.forEach(p -> p.fail(batchError));
            }
            this.sample.stop(t2, this.bytes, this.size());
        }

        @NonNull
        WriteRequest toProto() {
            Optional<Object> sessionInfo = this.containsEphemeral ? Optional.of(new Operation.WriteOperation.PutOperation.SessionInfo(this.sessionManager.getSession(this.getShardId()).getSessionId(), this.clientIdentifier)) : Optional.empty();
            return WriteRequest.newBuilder().setShardId(this.getShardId()).addAllPuts(this.puts.stream().map(p -> p.toProto(sessionInfo)).collect(Collectors.toList())).addAllDeletes(this.deletes.stream().map(Operation.WriteOperation.DeleteOperation::toProto).collect(Collectors.toList())).addAllDeleteRanges(this.deleteRanges.stream().map(Operation.WriteOperation.DeleteRangeOperation::toProto).collect(Collectors.toList())).build();
        }
    }
}

