/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client;

import io.streamnative.oxia.client.AsyncOxiaClientImpl;
import io.streamnative.oxia.client.CachingAsyncOxiaClient;
import io.streamnative.oxia.client.ClientConfig;
import io.streamnative.oxia.client.SyncOxiaClientImpl;
import io.streamnative.oxia.client.api.AsyncOxiaClient;
import io.streamnative.oxia.client.api.SyncOxiaClient;
import io.streamnative.oxia.client.metrics.api.Metrics;
import io.streamnative.pulsarmetadatastoreoxia.shaded.com.google.common.base.Strings;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import lombok.NonNull;

public class OxiaClientBuilder {
    public static final Duration DefaultBatchLinger = Duration.ofMillis(5L);
    public static final int DefaultMaxRequestsPerBatch = 1000;
    public static final int DefaultMaxBatchSize = 131072;
    public static final Duration DefaultRequestTimeout = Duration.ofSeconds(30L);
    public static final Duration DefaultSessionTimeout = Duration.ofSeconds(15L);
    public static final int DefaultRecordCacheCapacity = 10000;
    public static final String DefaultNamespace = "default";
    @NonNull
    private final String serviceAddress;
    @NonNull
    private Duration requestTimeout = DefaultRequestTimeout;
    @NonNull
    private Duration batchLinger = DefaultBatchLinger;
    private int maxRequestsPerBatch = 1000;
    private int recordCacheCapacity = 10000;
    @NonNull
    private Duration sessionTimeout = DefaultSessionTimeout;
    @NonNull
    private Supplier<String> clientIdentifier = OxiaClientBuilder::randomClientIdentifier;
    @NonNull
    private Metrics metrics = Metrics.nullObject;
    @NonNull
    private String namespace = "default";

    @NonNull
    public OxiaClientBuilder requestTimeout(@NonNull Duration requestTimeout) {
        if (requestTimeout == null) {
            throw new NullPointerException("requestTimeout is marked non-null but is null");
        }
        if (requestTimeout.isNegative() || requestTimeout.equals(Duration.ZERO)) {
            throw new IllegalArgumentException("requestTimeout must be greater than zero: " + requestTimeout);
        }
        this.requestTimeout = requestTimeout;
        return this;
    }

    @NonNull
    public OxiaClientBuilder batchLinger(@NonNull Duration batchLinger) {
        if (batchLinger == null) {
            throw new NullPointerException("batchLinger is marked non-null but is null");
        }
        if (batchLinger.isNegative() || batchLinger.equals(Duration.ZERO)) {
            throw new IllegalArgumentException("batchLinger must be greater than zero: " + batchLinger);
        }
        this.batchLinger = batchLinger;
        return this;
    }

    @NonNull
    public OxiaClientBuilder maxRequestsPerBatch(int maxRequestsPerBatch) {
        if (maxRequestsPerBatch <= 0) {
            throw new IllegalArgumentException("MaxRequestsPerBatch must be greater than zero: " + maxRequestsPerBatch);
        }
        this.maxRequestsPerBatch = maxRequestsPerBatch;
        return this;
    }

    @NonNull
    public OxiaClientBuilder recordCacheCapacity(int recordCacheCapacity) {
        if (recordCacheCapacity <= 0) {
            throw new IllegalArgumentException("recordCacheCapacity must be greater than zero: " + recordCacheCapacity);
        }
        this.recordCacheCapacity = recordCacheCapacity;
        return this;
    }

    @NonNull
    public OxiaClientBuilder namespace(@NonNull String namespace) {
        if (namespace == null) {
            throw new NullPointerException("namespace is marked non-null but is null");
        }
        if (Strings.isNullOrEmpty(namespace)) {
            throw new IllegalArgumentException("namespace must not be null or empty.");
        }
        this.namespace = namespace;
        return this;
    }

    @NonNull
    public OxiaClientBuilder disableRecordCache() {
        this.recordCacheCapacity = 0;
        return this;
    }

    @NonNull
    public OxiaClientBuilder sessionTimeout(@NonNull Duration sessionTimeout) {
        if (sessionTimeout == null) {
            throw new NullPointerException("sessionTimeout is marked non-null but is null");
        }
        if (sessionTimeout.isNegative() || sessionTimeout.equals(Duration.ZERO)) {
            throw new IllegalArgumentException("SessionTimeout must be greater than zero: " + sessionTimeout);
        }
        this.sessionTimeout = sessionTimeout;
        return this;
    }

    @NonNull
    public OxiaClientBuilder clientIdentifier(@NonNull String clientIdentifier) {
        if (clientIdentifier == null) {
            throw new NullPointerException("clientIdentifier is marked non-null but is null");
        }
        this.clientIdentifier = () -> clientIdentifier;
        return this;
    }

    @NonNull
    public OxiaClientBuilder clientIdentifier(@NonNull Supplier<String> clientIdentifier) {
        if (clientIdentifier == null) {
            throw new NullPointerException("clientIdentifier is marked non-null but is null");
        }
        this.clientIdentifier = clientIdentifier;
        return this;
    }

    @NonNull
    public OxiaClientBuilder metrics(@NonNull Metrics metrics) {
        if (metrics == null) {
            throw new NullPointerException("metrics is marked non-null but is null");
        }
        this.metrics = metrics;
        return this;
    }

    @NonNull
    public CompletableFuture<AsyncOxiaClient> asyncClient() {
        ClientConfig config = new ClientConfig(this.serviceAddress, this.requestTimeout, this.batchLinger, this.maxRequestsPerBatch, 131072, this.recordCacheCapacity, this.sessionTimeout, this.clientIdentifier.get(), this.metrics, this.namespace);
        CompletableFuture<AsyncOxiaClient> async = AsyncOxiaClientImpl.newInstance(config);
        if (config.recordCacheCapacity() > 0) {
            return async.thenApply(a -> new CachingAsyncOxiaClient(config, (AsyncOxiaClient)a));
        }
        return async;
    }

    @NonNull
    public SyncOxiaClient syncClient() {
        return new SyncOxiaClientImpl(this.asyncClient().join());
    }

    @NonNull
    public static String randomClientIdentifier() {
        return "oxia-client-java:" + UUID.randomUUID();
    }

    public OxiaClientBuilder(@NonNull String serviceAddress) {
        if (serviceAddress == null) {
            throw new NullPointerException("serviceAddress is marked non-null but is null");
        }
        this.serviceAddress = serviceAddress;
    }
}

