/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client;

import io.streamnative.oxia.client.ClientConfig;
import io.streamnative.oxia.client.CompareWithSlash;
import io.streamnative.oxia.client.api.AsyncOxiaClient;
import io.streamnative.oxia.client.api.DeleteOption;
import io.streamnative.oxia.client.api.GetResult;
import io.streamnative.oxia.client.api.Notification;
import io.streamnative.oxia.client.api.PutOption;
import io.streamnative.oxia.client.api.PutResult;
import io.streamnative.oxia.client.metrics.CacheMetrics;
import io.streamnative.oxia.client.metrics.api.Metrics;
import io.streamnative.pulsarmetadatastoreoxia.shaded.com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import io.streamnative.pulsarmetadatastoreoxia.shaded.com.github.benmanes.caffeine.cache.Caffeine;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.NonNull;

class CachingAsyncOxiaClient
implements AsyncOxiaClient {
    @NonNull
    private final AsyncOxiaClient delegate;
    @NonNull
    private final AsyncLoadingCache<String, GetResult> recordCache;

    CachingAsyncOxiaClient(ClientConfig config, AsyncOxiaClient delegate) {
        this(delegate, new CacheFactory(config, delegate));
    }

    CachingAsyncOxiaClient(@NonNull AsyncOxiaClient delegate, @NonNull Supplier<AsyncLoadingCache<String, GetResult>> cacheFactory) {
        if (delegate == null) {
            throw new NullPointerException("delegate is marked non-null but is null");
        }
        if (cacheFactory == null) {
            throw new NullPointerException("cacheFactory is marked non-null but is null");
        }
        this.delegate = delegate;
        this.recordCache = cacheFactory.get();
        delegate.notifications(n -> this.recordCache.synchronous().invalidate(n.key()));
    }

    @Override
    @NonNull
    public CompletableFuture<PutResult> put(@NonNull String key, byte @NonNull [] value, PutOption ... options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        this.recordCache.synchronous().invalidate(key);
        return this.delegate.put(key, value, options);
    }

    @Override
    @NonNull
    public CompletableFuture<Boolean> delete(@NonNull String key, DeleteOption ... options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        this.recordCache.synchronous().invalidate(key);
        return this.delegate.delete(key, options);
    }

    @Override
    @NonNull
    public CompletableFuture<Void> deleteRange(@NonNull String startKeyInclusive, @NonNull String endKeyExclusive) {
        if (startKeyInclusive == null) {
            throw new NullPointerException("startKeyInclusive is marked non-null but is null");
        }
        if (endKeyExclusive == null) {
            throw new NullPointerException("endKeyExclusive is marked non-null but is null");
        }
        List<String> cachedKeysInRange = this.recordCache.asMap().keySet().stream().filter(CompareWithSlash.withinRange(startKeyInclusive, endKeyExclusive)).toList();
        this.recordCache.synchronous().invalidateAll(cachedKeysInRange);
        return this.delegate.deleteRange(startKeyInclusive, endKeyExclusive);
    }

    @Override
    @NonNull
    public CompletableFuture<GetResult> get(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.recordCache.get(key);
    }

    @Override
    @NonNull
    public CompletableFuture<List<String>> list(@NonNull String startKeyInclusive, @NonNull String endKeyExclusive) {
        if (startKeyInclusive == null) {
            throw new NullPointerException("startKeyInclusive is marked non-null but is null");
        }
        if (endKeyExclusive == null) {
            throw new NullPointerException("endKeyExclusive is marked non-null but is null");
        }
        return this.delegate.list(startKeyInclusive, endKeyExclusive);
    }

    @Override
    public void notifications(@NonNull Consumer<Notification> notificationCallback) {
        if (notificationCallback == null) {
            throw new NullPointerException("notificationCallback is marked non-null but is null");
        }
        this.delegate.notifications(notificationCallback);
    }

    @Override
    public void close() throws Exception {
        this.delegate.close();
    }

    static class CacheFactory
    implements Supplier<AsyncLoadingCache<String, GetResult>> {
        @NonNull
        private final ClientConfig config;
        @NonNull
        private final AsyncOxiaClient delegate;
        @NonNull
        private final Supplier<CacheMetrics> cacheMetricsFactory;

        CacheFactory(ClientConfig config, AsyncOxiaClient delegate) {
            this(config, delegate, () -> CacheMetrics.create(config.metrics()));
        }

        @Override
        @NonNull
        public AsyncLoadingCache<String, GetResult> get() {
            Caffeine<Object, Object> builder = Caffeine.newBuilder().maximumSize(this.config.recordCacheCapacity());
            if (this.config.metrics() != Metrics.nullObject) {
                builder.recordStats(this.cacheMetricsFactory::get);
            }
            return builder.buildAsync((key, executor) -> this.delegate.get((String)key));
        }

        CacheFactory(@NonNull ClientConfig config, @NonNull AsyncOxiaClient delegate, @NonNull Supplier<CacheMetrics> cacheMetricsFactory) {
            if (config == null) {
                throw new NullPointerException("config is marked non-null but is null");
            }
            if (delegate == null) {
                throw new NullPointerException("delegate is marked non-null but is null");
            }
            if (cacheMetricsFactory == null) {
                throw new NullPointerException("cacheMetricsFactory is marked non-null but is null");
            }
            this.config = config;
            this.delegate = delegate;
            this.cacheMetricsFactory = cacheMetricsFactory;
        }
    }
}

