/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client.metrics.opentelemetry;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.api.metrics.Meter;
import io.streamnative.oxia.client.metrics.api.Metrics;
import java.util.List;
import java.util.Map;

public class OpenTelemetryMetrics
implements Metrics {
    private final Meter meter;

    public static Metrics create(OpenTelemetry openTelemetry) {
        Meter meter = openTelemetry.getMeter("oxia_client");
        return new OpenTelemetryMetrics(meter);
    }

    public Metrics.Histogram histogram(String name, Metrics.Unit unit) {
        LongHistogram histogram = this.meter.histogramBuilder(name).ofLongs().setExplicitBucketBoundariesAdvice(List.of(0L, 1L, 2L, 5L, 10L, 20L, 30L, 50L, 75L, 100L, 200L, 500L, 1000L, 10000L, 30000L, 60000L)).setUnit(this.unit(unit)).build();
        return (value, attributes) -> histogram.record(value, this.attributes(attributes));
    }

    private String unit(Metrics.Unit unit) {
        return switch (unit) {
            case Metrics.Unit.BYTES -> "By";
            case Metrics.Unit.MILLISECONDS -> "ms";
            default -> "1";
        };
    }

    private Attributes attributes(Map<String, String> attributes) {
        AttributesBuilder builder = Attributes.builder();
        attributes.forEach((arg_0, arg_1) -> ((AttributesBuilder)builder).put(arg_0, arg_1));
        return builder.build();
    }

    OpenTelemetryMetrics(Meter meter) {
        this.meter = meter;
    }
}

