/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.util.keystoretls;

import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.AuthenticationDataProvider;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.KeyStoreParams;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.util.FileModifiedTimeUpdater;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.util.SslContextAutoRefreshBuilder;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.util.keystoretls.KeyStoreSSLContext;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Set;

public class NettySSLContextAutoRefreshBuilder
extends SslContextAutoRefreshBuilder<KeyStoreSSLContext> {
    private volatile KeyStoreSSLContext keyStoreSSLContext;
    protected final boolean tlsAllowInsecureConnection;
    protected final Set<String> tlsCiphers;
    protected final Set<String> tlsProtocols;
    protected boolean tlsRequireTrustedClientCertOnConnect;
    protected final String tlsProvider;
    protected final String tlsTrustStoreType;
    protected final String tlsTrustStorePassword;
    protected final FileModifiedTimeUpdater tlsTrustStore;
    protected String tlsKeyStoreType;
    protected String tlsKeyStorePassword;
    protected FileModifiedTimeUpdater tlsKeyStore;
    protected final boolean isServer;

    public NettySSLContextAutoRefreshBuilder(String sslProviderString, String keyStoreTypeString, String keyStore, String keyStorePassword, boolean allowInsecureConnection, String trustStoreTypeString, String trustStore, String trustStorePassword, boolean requireTrustedClientCertOnConnect, Set<String> ciphers, Set<String> protocols, long certRefreshInSec) {
        super(certRefreshInSec);
        this.tlsAllowInsecureConnection = allowInsecureConnection;
        this.tlsProvider = sslProviderString;
        this.tlsKeyStoreType = keyStoreTypeString;
        this.tlsKeyStore = new FileModifiedTimeUpdater(keyStore);
        this.tlsKeyStorePassword = keyStorePassword;
        this.tlsTrustStoreType = trustStoreTypeString;
        this.tlsTrustStore = new FileModifiedTimeUpdater(trustStore);
        this.tlsTrustStorePassword = trustStorePassword;
        this.tlsRequireTrustedClientCertOnConnect = requireTrustedClientCertOnConnect;
        this.tlsCiphers = ciphers;
        this.tlsProtocols = protocols;
        this.isServer = true;
    }

    public NettySSLContextAutoRefreshBuilder(String sslProviderString, boolean allowInsecureConnection, String trustStoreTypeString, String trustStore, String trustStorePassword, String keyStoreTypeString, String keyStore, String keyStorePassword, Set<String> ciphers, Set<String> protocols, long certRefreshInSec, AuthenticationDataProvider authData) {
        super(certRefreshInSec);
        KeyStoreParams authParams;
        this.tlsAllowInsecureConnection = allowInsecureConnection;
        this.tlsProvider = sslProviderString;
        if (authData != null && (authParams = authData.getTlsKeyStoreParams()) != null) {
            keyStoreTypeString = authParams.getKeyStoreType();
            keyStore = authParams.getKeyStorePath();
            keyStorePassword = authParams.getKeyStorePassword();
        }
        this.tlsKeyStoreType = keyStoreTypeString;
        this.tlsKeyStore = new FileModifiedTimeUpdater(keyStore);
        this.tlsKeyStorePassword = keyStorePassword;
        this.tlsTrustStoreType = trustStoreTypeString;
        this.tlsTrustStore = new FileModifiedTimeUpdater(trustStore);
        this.tlsTrustStorePassword = trustStorePassword;
        this.tlsCiphers = ciphers;
        this.tlsProtocols = protocols;
        this.isServer = false;
    }

    @Override
    public synchronized KeyStoreSSLContext update() throws GeneralSecurityException, IOException {
        this.keyStoreSSLContext = this.isServer ? KeyStoreSSLContext.createServerKeyStoreSslContext(this.tlsProvider, this.tlsKeyStoreType, this.tlsKeyStore.getFileName(), this.tlsKeyStorePassword, this.tlsAllowInsecureConnection, this.tlsTrustStoreType, this.tlsTrustStore.getFileName(), this.tlsTrustStorePassword, this.tlsRequireTrustedClientCertOnConnect, this.tlsCiphers, this.tlsProtocols) : KeyStoreSSLContext.createClientKeyStoreSslContext(this.tlsProvider, this.tlsKeyStoreType, this.tlsKeyStore.getFileName(), this.tlsKeyStorePassword, this.tlsAllowInsecureConnection, this.tlsTrustStoreType, this.tlsTrustStore.getFileName(), this.tlsTrustStorePassword, this.tlsCiphers, this.tlsProtocols);
        return this.keyStoreSSLContext;
    }

    @Override
    public KeyStoreSSLContext getSslContext() {
        return this.keyStoreSSLContext;
    }

    @Override
    public boolean needUpdate() {
        return this.tlsKeyStore != null && this.tlsKeyStore.checkAndRefresh() || this.tlsTrustStore != null && this.tlsTrustStore.checkAndRefresh();
    }
}

