/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.util.keystoretls;

import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.util.FileModifiedTimeUpdater;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.util.SslContextAutoRefreshBuilder;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.util.keystoretls.KeyStoreSSLContext;
import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;

public class NetSslContextBuilder
extends SslContextAutoRefreshBuilder<SSLContext> {
    private volatile SSLContext sslContext;
    protected final boolean tlsAllowInsecureConnection;
    protected final boolean tlsRequireTrustedClientCertOnConnect;
    protected final String tlsProvider;
    protected final String tlsKeyStoreType;
    protected final String tlsKeyStorePassword;
    protected final FileModifiedTimeUpdater tlsKeyStore;
    protected final String tlsTrustStoreType;
    protected final String tlsTrustStorePassword;
    protected final FileModifiedTimeUpdater tlsTrustStore;

    public NetSslContextBuilder(String sslProviderString, String keyStoreTypeString, String keyStore, String keyStorePasswordPath, boolean allowInsecureConnection, String trustStoreTypeString, String trustStore, String trustStorePasswordPath, boolean requireTrustedClientCertOnConnect, long certRefreshInSec) {
        super(certRefreshInSec);
        this.tlsAllowInsecureConnection = allowInsecureConnection;
        this.tlsProvider = sslProviderString;
        this.tlsKeyStoreType = keyStoreTypeString;
        this.tlsKeyStore = new FileModifiedTimeUpdater(keyStore);
        this.tlsKeyStorePassword = keyStorePasswordPath;
        this.tlsTrustStoreType = trustStoreTypeString;
        this.tlsTrustStore = new FileModifiedTimeUpdater(trustStore);
        this.tlsTrustStorePassword = trustStorePasswordPath;
        this.tlsRequireTrustedClientCertOnConnect = requireTrustedClientCertOnConnect;
    }

    @Override
    public synchronized SSLContext update() throws GeneralSecurityException, IOException {
        this.sslContext = KeyStoreSSLContext.createServerSslContext(this.tlsProvider, this.tlsKeyStoreType, this.tlsKeyStore.getFileName(), this.tlsKeyStorePassword, this.tlsAllowInsecureConnection, this.tlsTrustStoreType, this.tlsTrustStore.getFileName(), this.tlsTrustStorePassword, this.tlsRequireTrustedClientCertOnConnect);
        return this.sslContext;
    }

    @Override
    public SSLContext getSslContext() {
        return this.sslContext;
    }

    @Override
    public boolean needUpdate() {
        return this.tlsKeyStore.checkAndRefresh() || this.tlsTrustStore.checkAndRefresh();
    }
}

