/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.util;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SslContextAutoRefreshBuilder<T> {
    private static final Logger log = LoggerFactory.getLogger(SslContextAutoRefreshBuilder.class);
    protected final long refreshTime;
    protected long lastRefreshTime;

    public SslContextAutoRefreshBuilder(long certRefreshInSec) {
        this.refreshTime = TimeUnit.SECONDS.toMillis(certRefreshInSec);
        this.lastRefreshTime = -1L;
        if (log.isDebugEnabled()) {
            log.debug("Certs will be refreshed every {} seconds", (Object)certRefreshInSec);
        }
    }

    protected abstract T update() throws GeneralSecurityException, IOException;

    protected abstract T getSslContext();

    protected abstract boolean needUpdate();

    public T get() {
        T ctx = this.getSslContext();
        if (ctx == null) {
            try {
                this.update();
                this.lastRefreshTime = System.currentTimeMillis();
                return this.getSslContext();
            }
            catch (IOException | GeneralSecurityException e) {
                log.error("Exception while trying to refresh ssl Context {}", (Object)e.getMessage(), (Object)e);
            }
        } else {
            long now = System.currentTimeMillis();
            if ((this.refreshTime <= 0L || now > this.lastRefreshTime + this.refreshTime) && this.needUpdate()) {
                try {
                    ctx = this.update();
                    this.lastRefreshTime = now;
                }
                catch (IOException | GeneralSecurityException e) {
                    log.error("Exception while trying to refresh ssl Context {} ", (Object)e.getMessage(), (Object)e);
                }
            }
        }
        return ctx;
    }
}

