/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.util;

import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.admin.internal.data.AuthPoliciesImpl;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.functions.FunctionConfig;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.functions.FunctionState;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.functions.JsonIgnorePropertiesMixIn;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.AuthPolicies;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.AutoFailoverPolicyData;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.AutoFailoverPolicyDataImpl;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.AutoSubscriptionCreationOverride;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.AutoTopicCreationOverride;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.BacklogQuota;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.BookieAffinityGroupData;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.BookieInfo;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.BookiesClusterInfo;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.BrokerInfo;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.BrokerNamespaceIsolationData;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.BrokerNamespaceIsolationDataImpl;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.BrokerStatus;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.BundlesData;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.ClusterData;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.ClusterDataImpl;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.ConsumerStats;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.DelayedDeliveryPolicies;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.DispatchRate;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.FailureDomain;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.FailureDomainImpl;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.FunctionInstanceStats;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.FunctionInstanceStatsData;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.FunctionInstanceStatsDataBase;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.FunctionInstanceStatsDataBaseImpl;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.FunctionInstanceStatsDataImpl;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.FunctionInstanceStatsImpl;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.FunctionStats;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.FunctionStatsImpl;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.NamespaceIsolationData;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.NamespaceIsolationDataImpl;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.NonPersistentPartitionedTopicStats;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.NonPersistentPublisherStats;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.NonPersistentReplicatorStats;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.NonPersistentSubscriptionStats;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.NonPersistentTopicStats;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.OffloadPolicies;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.OffloadPoliciesImpl;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.PartitionedTopicStats;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.PublisherStats;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.ReplicatorStats;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.ResourceQuota;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.ResourceQuotaMixIn;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.SubscriptionStats;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.TenantInfo;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.TenantInfoImpl;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.TopicStats;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.impl.AutoSubscriptionCreationOverrideImpl;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.impl.AutoTopicCreationOverrideImpl;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.impl.BacklogQuotaImpl;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.impl.BookieAffinityGroupDataImpl;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.impl.BookieInfoImpl;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.impl.BookiesClusterInfoImpl;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.impl.BrokerInfoImpl;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.impl.BrokerStatusImpl;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.impl.BundlesDataImpl;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.impl.DelayedDeliveryPoliciesImpl;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.impl.DispatchRateImpl;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.stats.ConsumerStatsImpl;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.stats.NonPersistentPartitionedTopicStatsImpl;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.stats.NonPersistentPublisherStatsImpl;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.stats.NonPersistentReplicatorStatsImpl;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.stats.NonPersistentSubscriptionStatsImpl;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.stats.NonPersistentTopicStatsImpl;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.stats.PartitionedTopicStatsImpl;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.stats.PublisherStatsImpl;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.stats.ReplicatorStatsImpl;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.stats.SubscriptionStatsImpl;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.stats.TopicStatsImpl;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.stats.Metrics;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.stats.MetricsMixIn;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.util.ProtectedObjectMapper;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.ObjectReader;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.ObjectWriter;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.module.SimpleAbstractTypeResolver;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.pulsar.shade.com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import org.apache.pulsar.shade.com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import org.apache.pulsar.shade.com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import org.apache.pulsar.shade.com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import org.apache.pulsar.shade.org.apache.commons.lang3.ClassUtils;
import org.apache.pulsar.shade.org.apache.pulsar.policies.data.loadbalancer.LoadManagerReport;
import org.apache.pulsar.shade.org.apache.pulsar.policies.data.loadbalancer.LoadReportDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectMapperFactory {
    private static final Logger log = LoggerFactory.getLogger(ObjectMapperFactory.class);
    private static final AtomicReference<MapperReference> MAPPER_REFERENCE = new AtomicReference<MapperReference>(new MapperReference(ObjectMapperFactory.createObjectMapperInstance()));
    private static final AtomicReference<MapperReference> INSTANCE_WITH_INCLUDE_ALWAYS = new AtomicReference<MapperReference>(new MapperReference(ObjectMapperFactory.createObjectMapperWithIncludeAlways()));
    private static final AtomicReference<MapperReference> YAML_MAPPER_REFERENCE = new AtomicReference<MapperReference>(new MapperReference(ObjectMapperFactory.createYamlInstance()));

    private static ObjectMapper createObjectMapperInstance() {
        return ProtectedObjectMapper.protectedCopyOf(ObjectMapperFactory.configureObjectMapper(new ObjectMapper()));
    }

    private static ObjectMapper createObjectMapperWithIncludeAlways() {
        return MAPPER_REFERENCE.get().getObjectMapper().copy().setSerializationInclusion(JsonInclude.Include.ALWAYS);
    }

    public static ObjectMapper create() {
        return ObjectMapperFactory.getMapper().getObjectMapper().copy();
    }

    private static ObjectMapper createYamlInstance() {
        return ProtectedObjectMapper.protectedCopyOf(ObjectMapperFactory.configureObjectMapper(new ObjectMapper(new YAMLFactory())));
    }

    private static ObjectMapper configureObjectMapper(ObjectMapper mapper) {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.registerModule(new ParameterNamesModule()).registerModule(new Jdk8Module()).registerModule(new JavaTimeModule());
        ObjectMapperFactory.setAnnotationsModule(mapper);
        return mapper;
    }

    public static ObjectMapper createYaml() {
        return ObjectMapperFactory.getYamlMapper().getObjectMapper().copy();
    }

    public static MapperReference getMapper() {
        return MAPPER_REFERENCE.get();
    }

    public static MapperReference getMapperWithIncludeAlways() {
        return INSTANCE_WITH_INCLUDE_ALWAYS.get();
    }

    @Deprecated
    public static ObjectMapper getThreadLocal() {
        return ObjectMapperFactory.getMapper().getObjectMapper();
    }

    public static MapperReference getYamlMapper() {
        return YAML_MAPPER_REFERENCE.get();
    }

    @Deprecated
    public static ObjectMapper getThreadLocalYaml() {
        return ObjectMapperFactory.getYamlMapper().getObjectMapper();
    }

    private static void setAnnotationsModule(ObjectMapper mapper) {
        SimpleModule module = new SimpleModule("AnnotationsModule");
        SimpleAbstractTypeResolver resolver = new SimpleAbstractTypeResolver();
        resolver.addMapping(AutoFailoverPolicyData.class, AutoFailoverPolicyDataImpl.class);
        resolver.addMapping(BrokerNamespaceIsolationData.class, BrokerNamespaceIsolationDataImpl.class);
        resolver.addMapping(BacklogQuota.class, BacklogQuotaImpl.class);
        resolver.addMapping(ClusterData.class, ClusterDataImpl.class);
        resolver.addMapping(FailureDomain.class, FailureDomainImpl.class);
        resolver.addMapping(NamespaceIsolationData.class, NamespaceIsolationDataImpl.class);
        resolver.addMapping(TenantInfo.class, TenantInfoImpl.class);
        resolver.addMapping(OffloadPolicies.class, OffloadPoliciesImpl.class);
        resolver.addMapping(FunctionStats.class, FunctionStatsImpl.class);
        resolver.addMapping(FunctionInstanceStats.class, FunctionInstanceStatsImpl.class);
        resolver.addMapping(FunctionInstanceStatsData.class, FunctionInstanceStatsDataImpl.class);
        resolver.addMapping(FunctionInstanceStatsDataBase.class, FunctionInstanceStatsDataBaseImpl.class);
        resolver.addMapping(BundlesData.class, BundlesDataImpl.class);
        resolver.addMapping(BookieAffinityGroupData.class, BookieAffinityGroupDataImpl.class);
        resolver.addMapping(AuthPolicies.class, AuthPoliciesImpl.class);
        resolver.addMapping(AutoTopicCreationOverride.class, AutoTopicCreationOverrideImpl.class);
        resolver.addMapping(BookieInfo.class, BookieInfoImpl.class);
        resolver.addMapping(BookiesClusterInfo.class, BookiesClusterInfoImpl.class);
        resolver.addMapping(BrokerInfo.class, BrokerInfoImpl.class);
        resolver.addMapping(BrokerStatus.class, BrokerStatusImpl.class);
        resolver.addMapping(DelayedDeliveryPolicies.class, DelayedDeliveryPoliciesImpl.class);
        resolver.addMapping(DispatchRate.class, DispatchRateImpl.class);
        resolver.addMapping(TopicStats.class, TopicStatsImpl.class);
        resolver.addMapping(ConsumerStats.class, ConsumerStatsImpl.class);
        resolver.addMapping(NonPersistentPublisherStats.class, NonPersistentPublisherStatsImpl.class);
        resolver.addMapping(NonPersistentReplicatorStats.class, NonPersistentReplicatorStatsImpl.class);
        resolver.addMapping(NonPersistentSubscriptionStats.class, NonPersistentSubscriptionStatsImpl.class);
        resolver.addMapping(NonPersistentTopicStats.class, NonPersistentTopicStatsImpl.class);
        resolver.addMapping(PartitionedTopicStats.class, PartitionedTopicStatsImpl.class);
        resolver.addMapping(NonPersistentPartitionedTopicStats.class, NonPersistentPartitionedTopicStatsImpl.class);
        resolver.addMapping(PublisherStats.class, PublisherStatsImpl.class);
        resolver.addMapping(ReplicatorStats.class, ReplicatorStatsImpl.class);
        resolver.addMapping(SubscriptionStats.class, SubscriptionStatsImpl.class);
        resolver.addMapping(AutoSubscriptionCreationOverride.class, AutoSubscriptionCreationOverrideImpl.class);
        mapper.addMixIn(ResourceQuota.class, ResourceQuotaMixIn.class);
        mapper.addMixIn(FunctionConfig.class, JsonIgnorePropertiesMixIn.class);
        mapper.addMixIn(FunctionState.class, JsonIgnorePropertiesMixIn.class);
        mapper.addMixIn(Metrics.class, MetricsMixIn.class);
        try {
            ClassUtils.getClass("org.apache.pulsar.shade.org.apache.pulsar.policies.data.loadbalancer.LoadManagerReport");
            module.addDeserializer(LoadManagerReport.class, new LoadReportDeserializer());
        }
        catch (ClassNotFoundException e) {
            log.debug("Add LoadManagerReport deserializer failed because LoadManagerReport.class has been shaded", e);
        }
        module.setAbstractTypes(resolver);
        mapper.registerModule(module);
    }

    public static void clearCaches() {
        ObjectMapperFactory.clearTypeFactoryCache(ObjectMapperFactory.getMapper().getObjectMapper());
        ObjectMapperFactory.clearTypeFactoryCache(ObjectMapperFactory.getYamlMapper().getObjectMapper());
        ObjectMapperFactory.clearTypeFactoryCache(ObjectMapperFactory.getMapperWithIncludeAlways().getObjectMapper());
        ObjectMapperFactory.replaceSingletonInstances();
    }

    private static void clearTypeFactoryCache(ObjectMapper objectMapper) {
        objectMapper.getTypeFactory().clearCache();
    }

    private static void replaceSingletonInstances() {
        MAPPER_REFERENCE.set(new MapperReference(ObjectMapperFactory.createObjectMapperInstance()));
        INSTANCE_WITH_INCLUDE_ALWAYS.set(new MapperReference(ObjectMapperFactory.createObjectMapperWithIncludeAlways()));
        YAML_MAPPER_REFERENCE.set(new MapperReference(ObjectMapperFactory.createYamlInstance()));
    }

    public static class MapperReference {
        private final ObjectMapper objectMapper;
        private final ObjectWriter objectWriter;
        private final ObjectReader objectReader;

        MapperReference(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            this.objectWriter = objectMapper.writer();
            this.objectReader = objectMapper.reader();
        }

        public ObjectMapper getObjectMapper() {
            return this.objectMapper;
        }

        public ObjectWriter writer() {
            return this.objectWriter;
        }

        public ObjectReader reader() {
            return this.objectReader;
        }
    }
}

