/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.impl;

import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.naming.NamespaceName;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.AutoFailoverPolicy;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.NamespaceIsolationPolicy;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.BrokerStatus;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.NamespaceIsolationData;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.impl.AutoFailoverPolicyFactory;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;

public class NamespaceIsolationPolicyImpl
implements NamespaceIsolationPolicy {
    private List<String> namespaces;
    private List<String> primary;
    private List<String> secondary;
    private AutoFailoverPolicy autoFailoverPolicy;

    private boolean matchNamespaces(String fqnn) {
        for (String nsRegex : this.namespaces) {
            if (!fqnn.matches(nsRegex)) continue;
            return true;
        }
        return false;
    }

    private List<URL> getMatchedBrokers(List<String> brkRegexList, List<URL> availableBrokers) {
        ArrayList<URL> matchedBrokers = new ArrayList<URL>();
        for (URL brokerUrl : availableBrokers) {
            if (!this.matchesBrokerRegex(brkRegexList, brokerUrl.getHost())) continue;
            matchedBrokers.add(brokerUrl);
        }
        return matchedBrokers;
    }

    public NamespaceIsolationPolicyImpl(NamespaceIsolationData policyData) {
        this.namespaces = policyData.getNamespaces();
        this.primary = policyData.getPrimary();
        this.secondary = policyData.getSecondary();
        this.autoFailoverPolicy = AutoFailoverPolicyFactory.create(policyData.getAutoFailoverPolicy());
    }

    @Override
    public List<String> getPrimaryBrokers() {
        return this.primary;
    }

    @Override
    public List<String> getSecondaryBrokers() {
        return this.secondary;
    }

    @Override
    public List<URL> findPrimaryBrokers(List<URL> availableBrokers, NamespaceName namespace) {
        if (!this.matchNamespaces(namespace.toString())) {
            throw new IllegalArgumentException("Namespace " + namespace.toString() + " does not match policy");
        }
        return this.getMatchedBrokers(this.primary, availableBrokers);
    }

    @Override
    public List<URL> findSecondaryBrokers(List<URL> availableBrokers, NamespaceName namespace) {
        if (!this.matchNamespaces(namespace.toString())) {
            throw new IllegalArgumentException("Namespace " + namespace.toString() + " does not match policy");
        }
        return this.getMatchedBrokers(this.secondary, availableBrokers);
    }

    @Override
    public boolean shouldFallback(SortedSet<BrokerStatus> primaryBrokers) {
        return false;
    }

    private boolean matchesBrokerRegex(List<String> brkRegexList, String broker) {
        for (String brkRegex : brkRegexList) {
            if (!broker.matches(brkRegex)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPrimaryBroker(String broker) {
        return this.matchesBrokerRegex(this.primary, broker);
    }

    @Override
    public boolean isSecondaryBroker(String broker) {
        return this.matchesBrokerRegex(this.secondary, broker);
    }

    public int hashCode() {
        return Objects.hash(this.namespaces, this.primary, this.secondary, this.autoFailoverPolicy);
    }

    public boolean equals(Object obj) {
        if (obj instanceof NamespaceIsolationPolicyImpl) {
            NamespaceIsolationPolicyImpl other = (NamespaceIsolationPolicyImpl)obj;
            return Objects.equals(this.namespaces, other.namespaces) && Objects.equals(this.primary, other.primary) && Objects.equals(this.secondary, other.secondary) && Objects.equals(this.autoFailoverPolicy, other.autoFailoverPolicy);
        }
        return false;
    }

    @Override
    public SortedSet<BrokerStatus> getAvailablePrimaryBrokers(SortedSet<BrokerStatus> primaryCandidates) {
        TreeSet<BrokerStatus> availablePrimaries = new TreeSet<BrokerStatus>();
        for (BrokerStatus status : primaryCandidates) {
            if (!this.autoFailoverPolicy.isBrokerAvailable(status)) continue;
            availablePrimaries.add(status);
        }
        return availablePrimaries;
    }

    @Override
    public boolean shouldFailover(SortedSet<BrokerStatus> brokerStatus) {
        return this.autoFailoverPolicy.shouldFailoverToSecondary(brokerStatus);
    }

    @Override
    public boolean shouldFailover(int totalPrimaryResourceUnits) {
        return this.autoFailoverPolicy.shouldFailoverToSecondary(totalPrimaryResourceUnits);
    }

    @Override
    public boolean isPrimaryBrokerAvailable(BrokerStatus brkStatus) {
        return this.isPrimaryBroker(brkStatus.getBrokerAddress()) && this.autoFailoverPolicy.isBrokerAvailable(brkStatus);
    }

    public String toString() {
        return String.format("namespaces=%s primary=%s secondary=%s auto_failover_policy=%s", this.namespaces, this.primary, this.secondary, this.autoFailoverPolicy);
    }
}

