/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.impl;

import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.AutoFailoverPolicy;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.AutoFailoverPolicyData;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.AutoFailoverPolicyType;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.BrokerStatus;
import java.util.SortedSet;

public class MinAvailablePolicy
extends AutoFailoverPolicy {
    private static final String MIN_LIMIT_KEY = "min_limit";
    private static final String USAGE_THRESHOLD_KEY = "usage_threshold";
    private static final int MAX_USAGE_THRESHOLD = 100;
    public int min_limit;
    public int usage_threshold;

    public MinAvailablePolicy(AutoFailoverPolicyData policyData) {
        if (!policyData.getPolicyType().equals((Object)AutoFailoverPolicyType.min_available)) {
            throw new IllegalArgumentException();
        }
        if (!policyData.getParameters().containsKey(MIN_LIMIT_KEY)) {
            throw new IllegalArgumentException();
        }
        if (!policyData.getParameters().containsKey(USAGE_THRESHOLD_KEY)) {
            throw new IllegalArgumentException();
        }
        this.min_limit = Integer.parseInt(policyData.getParameters().get(MIN_LIMIT_KEY));
        this.usage_threshold = Integer.parseInt(policyData.getParameters().get(USAGE_THRESHOLD_KEY));
    }

    @Override
    public boolean isBrokerAvailable(BrokerStatus brokerStatus) {
        return brokerStatus.isActive() && (this.usage_threshold == 100 || brokerStatus.getLoadFactor() < this.usage_threshold);
    }

    @Override
    public boolean shouldFailoverToSecondary(SortedSet<BrokerStatus> primaryCandidates) {
        int numAvailablePrimaryBrokers = 0;
        for (BrokerStatus brkStatus : primaryCandidates) {
            if (!this.isBrokerAvailable(brkStatus)) continue;
            ++numAvailablePrimaryBrokers;
        }
        return numAvailablePrimaryBrokers < this.min_limit;
    }

    @Override
    public boolean shouldFailoverToSecondary(int totalPrimaryCandidates) {
        return totalPrimaryCandidates < this.min_limit;
    }

    public int getMin_limit() {
        return this.min_limit;
    }

    public int getUsage_threshold() {
        return this.usage_threshold;
    }

    public void setMin_limit(int min_limit) {
        this.min_limit = min_limit;
    }

    public void setUsage_threshold(int usage_threshold) {
        this.usage_threshold = usage_threshold;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MinAvailablePolicy)) {
            return false;
        }
        MinAvailablePolicy other = (MinAvailablePolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMin_limit() != other.getMin_limit()) {
            return false;
        }
        return this.getUsage_threshold() == other.getUsage_threshold();
    }

    protected boolean canEqual(Object other) {
        return other instanceof MinAvailablePolicy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMin_limit();
        result = result * 59 + this.getUsage_threshold();
        return result;
    }

    public String toString() {
        return "MinAvailablePolicy(min_limit=" + this.getMin_limit() + ", usage_threshold=" + this.getUsage_threshold() + ")";
    }

    public MinAvailablePolicy(int min_limit, int usage_threshold) {
        this.min_limit = min_limit;
        this.usage_threshold = usage_threshold;
    }
}

