/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data;

import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.BookieInfo;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;

public class BookiesRackConfiguration
extends TreeMap<String, Map<String, BookieInfo>> {
    private static final long serialVersionUID = 0L;

    public synchronized boolean removeBookie(String address) {
        for (Map.Entry entry : this.entrySet()) {
            if (((Map)entry.getValue()).remove(address) == null) continue;
            if (((Map)entry.getValue()).isEmpty()) {
                this.remove(entry.getKey());
            }
            return true;
        }
        return false;
    }

    public synchronized Optional<BookieInfo> getBookie(String address) {
        for (Map m3 : this.values()) {
            BookieInfo bi = (BookieInfo)m3.get(address);
            if (bi == null) continue;
            return Optional.of(bi);
        }
        return Optional.empty();
    }

    public synchronized void updateBookie(String group, String address, BookieInfo bookieInfo) {
        Objects.requireNonNull(group);
        Objects.requireNonNull(address);
        Objects.requireNonNull(bookieInfo);
        this.removeBookie(address);
        this.computeIfAbsent(group, key -> new TreeMap()).put(address, bookieInfo);
    }
}

