/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.nar;

import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.nar.NarClassLoader;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;

public class NarClassLoaderBuilder {
    private File narFile;
    private Set<String> additionalJars;
    private ClassLoader parentClassLoader;
    private String extractionDirectory;

    public static NarClassLoaderBuilder builder() {
        return new NarClassLoaderBuilder();
    }

    public NarClassLoaderBuilder narFile(File narFile) {
        this.narFile = narFile;
        return this;
    }

    public NarClassLoaderBuilder additionalJars(Set<String> additionalJars) {
        this.additionalJars = additionalJars;
        return this;
    }

    public NarClassLoaderBuilder parentClassLoader(ClassLoader parentClassLoader) {
        this.parentClassLoader = parentClassLoader;
        return this;
    }

    public NarClassLoaderBuilder extractionDirectory(String extractionDirectory) {
        this.extractionDirectory = extractionDirectory;
        return this;
    }

    public NarClassLoader build() throws IOException {
        if (this.parentClassLoader == null) {
            this.parentClassLoader = NarClassLoader.class.getClassLoader();
        }
        if (this.extractionDirectory == null) {
            this.extractionDirectory = NarClassLoader.DEFAULT_NAR_EXTRACTION_DIR;
        }
        Objects.requireNonNull(this.narFile);
        return NarClassLoader.getFromArchive(this.narFile, this.additionalJars, this.parentClassLoader, this.extractionDirectory);
    }
}

