/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.intercept;

import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.api.proto.BrokerEntryMetadata;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.intercept.BrokerEntryMetadataInterceptor;
import java.util.concurrent.atomic.AtomicLong;

public class AppendIndexMetadataInterceptor
implements BrokerEntryMetadataInterceptor {
    private final AtomicLong indexGenerator = new AtomicLong(-1L);

    public void recoveryIndexGenerator(long index) {
        if (this.indexGenerator.get() < index) {
            this.indexGenerator.set(index);
        }
    }

    @Override
    public BrokerEntryMetadata intercept(BrokerEntryMetadata brokerMetadata) {
        return brokerMetadata;
    }

    @Override
    public BrokerEntryMetadata interceptWithNumberOfMessages(BrokerEntryMetadata brokerMetadata, int numberOfMessages) {
        return brokerMetadata.setIndex(this.indexGenerator.addAndGet(numberOfMessages));
    }

    public long getIndex() {
        return this.indexGenerator.get();
    }

    public void decreaseWithNumberOfMessages(int numberOfMessages) {
        this.indexGenerator.addAndGet(-numberOfMessages);
    }
}

