/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.compression;

import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.CompressionType;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.compression.CompressionCodec;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.compression.CompressionCodecLZ4;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.compression.CompressionCodecNone;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.compression.CompressionCodecSnappy;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.compression.CompressionCodecZLib;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.compression.CompressionCodecZstd;
import java.util.EnumMap;

public final class CompressionCodecProvider {
    private static final EnumMap<com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.api.proto.CompressionType, CompressionCodec> codecs = new EnumMap(com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.api.proto.CompressionType.class);

    public static CompressionCodec getCompressionCodec(com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.api.proto.CompressionType type) {
        return codecs.get((Object)type);
    }

    public static CompressionCodec getCompressionCodec(CompressionType type) {
        return codecs.get((Object)CompressionCodecProvider.convertToWireProtocol(type));
    }

    public static com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.api.proto.CompressionType convertToWireProtocol(CompressionType compressionType) {
        switch (compressionType) {
            case NONE: {
                return com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.api.proto.CompressionType.NONE;
            }
            case LZ4: {
                return com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.api.proto.CompressionType.LZ4;
            }
            case ZLIB: {
                return com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.api.proto.CompressionType.ZLIB;
            }
            case ZSTD: {
                return com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.api.proto.CompressionType.ZSTD;
            }
            case SNAPPY: {
                return com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.api.proto.CompressionType.SNAPPY;
            }
        }
        throw new RuntimeException("Invalid compression type");
    }

    public static CompressionType convertFromWireProtocol(com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.api.proto.CompressionType compressionType) {
        switch (compressionType) {
            case NONE: {
                return CompressionType.NONE;
            }
            case LZ4: {
                return CompressionType.LZ4;
            }
            case ZLIB: {
                return CompressionType.ZLIB;
            }
            case ZSTD: {
                return CompressionType.ZSTD;
            }
            case SNAPPY: {
                return CompressionType.SNAPPY;
            }
        }
        throw new RuntimeException("Invalid compression type");
    }

    private CompressionCodecProvider() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        codecs.put(com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.api.proto.CompressionType.NONE, new CompressionCodecNone());
        codecs.put(com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.api.proto.CompressionType.LZ4, new CompressionCodecLZ4());
        codecs.put(com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.api.proto.CompressionType.ZLIB, new CompressionCodecZLib());
        codecs.put(com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.api.proto.CompressionType.ZSTD, new CompressionCodecZstd());
        codecs.put(com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.api.proto.CompressionType.SNAPPY, new CompressionCodecSnappy());
    }
}

