/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.compression;

import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.allocator.PulsarByteBufAllocator;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.compression.AirliftUtils;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.compression.CompressionCodec;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.pulsar.shade.io.airlift.compress.lz4.Lz4Compressor;
import org.apache.pulsar.shade.io.airlift.compress.lz4.Lz4Decompressor;
import org.apache.pulsar.shade.io.airlift.compress.lz4.Lz4RawCompressor;
import org.apache.pulsar.shade.io.airlift.compress.lz4.Lz4RawDecompressor;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.util.concurrent.FastThreadLocal;

public class CompressionCodecLZ4
implements CompressionCodec {
    private static final FastThreadLocal<Lz4Compressor> LZ4_COMPRESSOR = new FastThreadLocal<Lz4Compressor>(){

        @Override
        protected Lz4Compressor initialValue() throws Exception {
            return new Lz4Compressor();
        }
    };
    private static final FastThreadLocal<Lz4Decompressor> LZ4_DECOMPRESSOR = new FastThreadLocal<Lz4Decompressor>(){

        @Override
        protected Lz4Decompressor initialValue() throws Exception {
            return new Lz4Decompressor();
        }
    };
    private static final FastThreadLocal<int[]> LZ4_TABLE = new FastThreadLocal<int[]>(){

        @Override
        protected int[] initialValue() throws Exception {
            return new int[4096];
        }
    };

    @Override
    public ByteBuf encode(ByteBuf source) {
        int compressedLength;
        int uncompressedLength = source.readableBytes();
        int maxLength = Lz4RawCompressor.maxCompressedLength(uncompressedLength);
        ByteBuf target = PulsarByteBufAllocator.DEFAULT.buffer(maxLength, maxLength);
        if (source.hasMemoryAddress() && target.hasMemoryAddress()) {
            compressedLength = Lz4RawCompressor.compress(null, source.memoryAddress() + (long)source.readerIndex(), source.readableBytes(), null, target.memoryAddress(), maxLength, LZ4_TABLE.get());
        } else {
            ByteBuffer sourceNio = source.nioBuffer(source.readerIndex(), source.readableBytes());
            ByteBuffer targetNio = target.nioBuffer(0, maxLength);
            LZ4_COMPRESSOR.get().compress(sourceNio, targetNio);
            compressedLength = targetNio.position();
        }
        target.writerIndex(compressedLength);
        return target;
    }

    @Override
    public ByteBuf decode(ByteBuf encoded, int uncompressedLength) throws IOException {
        ByteBuf uncompressed = PulsarByteBufAllocator.DEFAULT.buffer(uncompressedLength, uncompressedLength);
        if (encoded.hasMemoryAddress() && uncompressed.hasMemoryAddress()) {
            Lz4RawDecompressor.decompress(null, encoded.memoryAddress() + (long)encoded.readerIndex(), encoded.memoryAddress() + (long)encoded.writerIndex(), null, uncompressed.memoryAddress(), uncompressed.memoryAddress() + (long)uncompressedLength);
        } else {
            ByteBuffer uncompressedNio = uncompressed.nioBuffer(0, uncompressedLength);
            ByteBuffer encodedNio = encoded.nioBuffer(encoded.readerIndex(), encoded.readableBytes());
            encodedNio = AirliftUtils.ensureAirliftSupported(encodedNio);
            LZ4_DECOMPRESSOR.get().decompress(encodedNio, uncompressedNio);
        }
        uncompressed.writerIndex(uncompressedLength);
        return uncompressed;
    }
}

