/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.api.proto;

import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.api.proto.IntRange;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.api.proto.KeySharedMode;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.api.proto.LightProtoCodec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.Unpooled;

public final class KeySharedMeta {
    private KeySharedMode keySharedMode;
    private static final int _KEY_SHARED_MODE_FIELD_NUMBER = 1;
    private static final int _KEY_SHARED_MODE_TAG = 8;
    private static final int _KEY_SHARED_MODE_TAG_SIZE = LightProtoCodec.computeVarIntSize(8);
    private static final int _KEY_SHARED_MODE_MASK = 1;
    private List<IntRange> hashRanges = null;
    private int _hashRangesCount = 0;
    private static final int _HASH_RANGES_FIELD_NUMBER = 3;
    private static final int _HASH_RANGES_TAG = 26;
    private static final int _HASH_RANGES_TAG_SIZE = LightProtoCodec.computeVarIntSize(26);
    private boolean allowOutOfOrderDelivery = false;
    private static final int _ALLOW_OUT_OF_ORDER_DELIVERY_FIELD_NUMBER = 4;
    private static final int _ALLOW_OUT_OF_ORDER_DELIVERY_TAG = 32;
    private static final int _ALLOW_OUT_OF_ORDER_DELIVERY_TAG_SIZE = LightProtoCodec.computeVarIntSize(32);
    private static final int _ALLOW_OUT_OF_ORDER_DELIVERY_MASK = 4;
    private int _bitField0;
    private static final int _REQUIRED_FIELDS_MASK0 = 1;
    private int _cachedSize;
    private ByteBuf _parsedBuffer;

    public boolean hasKeySharedMode() {
        return (this._bitField0 & 1) != 0;
    }

    public KeySharedMode getKeySharedMode() {
        if (!this.hasKeySharedMode()) {
            throw new IllegalStateException("Field 'keySharedMode' is not set");
        }
        return this.keySharedMode;
    }

    public KeySharedMeta setKeySharedMode(KeySharedMode keySharedMode) {
        this.keySharedMode = keySharedMode;
        this._bitField0 |= 1;
        this._cachedSize = -1;
        return this;
    }

    public KeySharedMeta clearKeySharedMode() {
        this._bitField0 &= 0xFFFFFFFE;
        return this;
    }

    public int getHashRangesCount() {
        return this._hashRangesCount;
    }

    public IntRange getHashRangeAt(int idx) {
        if (idx < 0 || idx >= this._hashRangesCount) {
            throw new IndexOutOfBoundsException("Index " + idx + " is out of the list size (" + this._hashRangesCount + ") for field 'hashRanges'");
        }
        return this.hashRanges.get(idx);
    }

    public List<IntRange> getHashRangesList() {
        if (this._hashRangesCount == 0) {
            return Collections.emptyList();
        }
        return this.hashRanges.subList(0, this._hashRangesCount);
    }

    public IntRange addHashRange() {
        if (this.hashRanges == null) {
            this.hashRanges = new ArrayList<IntRange>();
        }
        if (this.hashRanges.size() == this._hashRangesCount) {
            this.hashRanges.add(new IntRange());
        }
        this._cachedSize = -1;
        return this.hashRanges.get(this._hashRangesCount++);
    }

    public KeySharedMeta addAllHashRanges(Iterable<IntRange> hashRanges) {
        for (IntRange _o : hashRanges) {
            this.addHashRange().copyFrom(_o);
        }
        return this;
    }

    public KeySharedMeta clearHashRanges() {
        for (int i = 0; i < this._hashRangesCount; ++i) {
            this.hashRanges.get(i).clear();
        }
        this._hashRangesCount = 0;
        return this;
    }

    public boolean hasAllowOutOfOrderDelivery() {
        return (this._bitField0 & 4) != 0;
    }

    public boolean isAllowOutOfOrderDelivery() {
        return this.allowOutOfOrderDelivery;
    }

    public KeySharedMeta setAllowOutOfOrderDelivery(boolean allowOutOfOrderDelivery) {
        this.allowOutOfOrderDelivery = allowOutOfOrderDelivery;
        this._bitField0 |= 4;
        this._cachedSize = -1;
        return this;
    }

    public KeySharedMeta clearAllowOutOfOrderDelivery() {
        this._bitField0 &= 0xFFFFFFFB;
        this.allowOutOfOrderDelivery = false;
        return this;
    }

    public int writeTo(ByteBuf _b) {
        this.checkRequiredFields();
        int _writeIdx = _b.writerIndex();
        LightProtoCodec.writeVarInt(_b, 8);
        LightProtoCodec.writeVarInt(_b, this.keySharedMode.getValue());
        for (int i = 0; i < this._hashRangesCount; ++i) {
            IntRange _item = this.hashRanges.get(i);
            LightProtoCodec.writeVarInt(_b, 26);
            LightProtoCodec.writeVarInt(_b, _item.getSerializedSize());
            _item.writeTo(_b);
        }
        if (this.hasAllowOutOfOrderDelivery()) {
            LightProtoCodec.writeVarInt(_b, 32);
            _b.writeBoolean(this.allowOutOfOrderDelivery);
        }
        return _b.writerIndex() - _writeIdx;
    }

    public int getSerializedSize() {
        if (this._cachedSize > -1) {
            return this._cachedSize;
        }
        int _size = 0;
        _size += _KEY_SHARED_MODE_TAG_SIZE;
        _size += LightProtoCodec.computeVarIntSize(this.keySharedMode.getValue());
        for (int i = 0; i < this._hashRangesCount; ++i) {
            IntRange _item = this.hashRanges.get(i);
            _size += _HASH_RANGES_TAG_SIZE;
            int MsgsizeHashRanges = _item.getSerializedSize();
            _size += LightProtoCodec.computeVarIntSize(MsgsizeHashRanges) + MsgsizeHashRanges;
        }
        if (this.hasAllowOutOfOrderDelivery()) {
            _size += _ALLOW_OUT_OF_ORDER_DELIVERY_TAG_SIZE;
            ++_size;
        }
        this._cachedSize = _size;
        return _size;
    }

    public void parseFrom(ByteBuf _buffer, int _size) {
        this.clear();
        int _endIdx = _buffer.readerIndex() + _size;
        block5: while (_buffer.readerIndex() < _endIdx) {
            int _tag = LightProtoCodec.readVarInt(_buffer);
            switch (_tag) {
                case 8: {
                    KeySharedMode _keySharedMode = KeySharedMode.valueOf(LightProtoCodec.readVarInt(_buffer));
                    if (_keySharedMode == null) continue block5;
                    this._bitField0 |= 1;
                    this.keySharedMode = _keySharedMode;
                    continue block5;
                }
                case 26: {
                    int _hashRangesSize = LightProtoCodec.readVarInt(_buffer);
                    this.addHashRange().parseFrom(_buffer, _hashRangesSize);
                    continue block5;
                }
                case 32: {
                    this._bitField0 |= 4;
                    this.allowOutOfOrderDelivery = LightProtoCodec.readVarInt(_buffer) == 1;
                    continue block5;
                }
            }
            LightProtoCodec.skipUnknownField(_tag, _buffer);
        }
        this.checkRequiredFields();
        this._parsedBuffer = _buffer;
    }

    private void checkRequiredFields() {
        if ((this._bitField0 & 1) != 1) {
            throw new IllegalStateException("Some required fields are missing");
        }
    }

    public KeySharedMeta clear() {
        for (int i = 0; i < this._hashRangesCount; ++i) {
            this.hashRanges.get(i).clear();
        }
        this._hashRangesCount = 0;
        this.allowOutOfOrderDelivery = false;
        this._parsedBuffer = null;
        this._cachedSize = -1;
        this._bitField0 = 0;
        return this;
    }

    public KeySharedMeta copyFrom(KeySharedMeta _other) {
        this._cachedSize = -1;
        if (_other.hasKeySharedMode()) {
            this.setKeySharedMode(_other.keySharedMode);
        }
        for (int i = 0; i < _other.getHashRangesCount(); ++i) {
            this.addHashRange().copyFrom(_other.getHashRangeAt(i));
        }
        if (_other.hasAllowOutOfOrderDelivery()) {
            this.setAllowOutOfOrderDelivery(_other.allowOutOfOrderDelivery);
        }
        return this;
    }

    public byte[] toByteArray() {
        byte[] a = new byte[this.getSerializedSize()];
        ByteBuf b = Unpooled.wrappedBuffer(a).writerIndex(0);
        this.writeTo(b);
        return a;
    }

    public void parseFrom(byte[] a) {
        ByteBuf b = Unpooled.wrappedBuffer(a);
        this.parseFrom(b, b.readableBytes());
    }
}

