/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.api.proto;

import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.api.proto.LightProtoCodec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.Unpooled;

public final class CommandAddPartitionToTxn {
    private long requestId;
    private static final int _REQUEST_ID_FIELD_NUMBER = 1;
    private static final int _REQUEST_ID_TAG = 8;
    private static final int _REQUEST_ID_TAG_SIZE = LightProtoCodec.computeVarIntSize(8);
    private static final int _REQUEST_ID_MASK = 1;
    private long txnidLeastBits = 0L;
    private static final int _TXNID_LEAST_BITS_FIELD_NUMBER = 2;
    private static final int _TXNID_LEAST_BITS_TAG = 16;
    private static final int _TXNID_LEAST_BITS_TAG_SIZE = LightProtoCodec.computeVarIntSize(16);
    private static final int _TXNID_LEAST_BITS_MASK = 2;
    private long txnidMostBits = 0L;
    private static final int _TXNID_MOST_BITS_FIELD_NUMBER = 3;
    private static final int _TXNID_MOST_BITS_TAG = 24;
    private static final int _TXNID_MOST_BITS_TAG_SIZE = LightProtoCodec.computeVarIntSize(24);
    private static final int _TXNID_MOST_BITS_MASK = 4;
    private List<LightProtoCodec.StringHolder> partitions = null;
    private int _partitionsCount = 0;
    private static final int _PARTITIONS_FIELD_NUMBER = 4;
    private static final int _PARTITIONS_TAG = 34;
    private static final int _PARTITIONS_TAG_SIZE = LightProtoCodec.computeVarIntSize(34);
    private int _bitField0;
    private static final int _REQUIRED_FIELDS_MASK0 = 1;
    private int _cachedSize;
    private ByteBuf _parsedBuffer;

    public boolean hasRequestId() {
        return (this._bitField0 & 1) != 0;
    }

    public long getRequestId() {
        if (!this.hasRequestId()) {
            throw new IllegalStateException("Field 'request_id' is not set");
        }
        return this.requestId;
    }

    public CommandAddPartitionToTxn setRequestId(long requestId) {
        this.requestId = requestId;
        this._bitField0 |= 1;
        this._cachedSize = -1;
        return this;
    }

    public CommandAddPartitionToTxn clearRequestId() {
        this._bitField0 &= 0xFFFFFFFE;
        return this;
    }

    public boolean hasTxnidLeastBits() {
        return (this._bitField0 & 2) != 0;
    }

    public long getTxnidLeastBits() {
        return this.txnidLeastBits;
    }

    public CommandAddPartitionToTxn setTxnidLeastBits(long txnidLeastBits) {
        this.txnidLeastBits = txnidLeastBits;
        this._bitField0 |= 2;
        this._cachedSize = -1;
        return this;
    }

    public CommandAddPartitionToTxn clearTxnidLeastBits() {
        this._bitField0 &= 0xFFFFFFFD;
        this.txnidLeastBits = 0L;
        return this;
    }

    public boolean hasTxnidMostBits() {
        return (this._bitField0 & 4) != 0;
    }

    public long getTxnidMostBits() {
        return this.txnidMostBits;
    }

    public CommandAddPartitionToTxn setTxnidMostBits(long txnidMostBits) {
        this.txnidMostBits = txnidMostBits;
        this._bitField0 |= 4;
        this._cachedSize = -1;
        return this;
    }

    public CommandAddPartitionToTxn clearTxnidMostBits() {
        this._bitField0 &= 0xFFFFFFFB;
        this.txnidMostBits = 0L;
        return this;
    }

    public int getPartitionsCount() {
        return this._partitionsCount;
    }

    public String getPartitionAt(int idx) {
        if (idx < 0 || idx >= this._partitionsCount) {
            throw new IndexOutOfBoundsException("Index " + idx + " is out of the list size (" + this._partitionsCount + ") for field 'partitions'");
        }
        LightProtoCodec.StringHolder _sh = this.partitions.get(idx);
        if (_sh.s == null) {
            _sh.s = LightProtoCodec.readString(this._parsedBuffer, _sh.idx, _sh.len);
        }
        return _sh.s;
    }

    public List<String> getPartitionsList() {
        if (this._partitionsCount == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> _l = new ArrayList<String>();
        for (int i = 0; i < this._partitionsCount; ++i) {
            _l.add(this.getPartitionAt(i));
        }
        return _l;
    }

    public void addPartition(String partition) {
        if (this.partitions == null) {
            this.partitions = new ArrayList<LightProtoCodec.StringHolder>();
        }
        LightProtoCodec.StringHolder _sh = this._newPartitionStringHolder();
        this._cachedSize = -1;
        _sh.s = partition;
        _sh.idx = -1;
        _sh.len = LightProtoCodec.computeStringUTF8Size(_sh.s);
    }

    public CommandAddPartitionToTxn addAllPartitions(Iterable<String> partitions) {
        for (String _s : partitions) {
            this.addPartition(_s);
        }
        return this;
    }

    private LightProtoCodec.StringHolder _newPartitionStringHolder() {
        LightProtoCodec.StringHolder _sh;
        if (this.partitions == null) {
            this.partitions = new ArrayList<LightProtoCodec.StringHolder>();
        }
        if (this.partitions.size() == this._partitionsCount) {
            _sh = new LightProtoCodec.StringHolder();
            this.partitions.add(_sh);
        } else {
            _sh = this.partitions.get(this._partitionsCount);
        }
        ++this._partitionsCount;
        return _sh;
    }

    public CommandAddPartitionToTxn clearPartitions() {
        for (int i = 0; i < this._partitionsCount; ++i) {
            LightProtoCodec.StringHolder _sh = this.partitions.get(i);
            _sh.s = null;
            _sh.idx = -1;
            _sh.len = -1;
        }
        this._partitionsCount = 0;
        return this;
    }

    public int writeTo(ByteBuf _b) {
        this.checkRequiredFields();
        int _writeIdx = _b.writerIndex();
        LightProtoCodec.writeVarInt(_b, 8);
        LightProtoCodec.writeVarInt64(_b, this.requestId);
        if (this.hasTxnidLeastBits()) {
            LightProtoCodec.writeVarInt(_b, 16);
            LightProtoCodec.writeVarInt64(_b, this.txnidLeastBits);
        }
        if (this.hasTxnidMostBits()) {
            LightProtoCodec.writeVarInt(_b, 24);
            LightProtoCodec.writeVarInt64(_b, this.txnidMostBits);
        }
        for (int i = 0; i < this._partitionsCount; ++i) {
            LightProtoCodec.StringHolder _sh = this.partitions.get(i);
            LightProtoCodec.writeVarInt(_b, 34);
            LightProtoCodec.writeVarInt(_b, _sh.len);
            if (_sh.idx == -1) {
                LightProtoCodec.writeString(_b, _sh.s, _sh.len);
                continue;
            }
            this._parsedBuffer.getBytes(_sh.idx, _b, _sh.len);
        }
        return _b.writerIndex() - _writeIdx;
    }

    public int getSerializedSize() {
        if (this._cachedSize > -1) {
            return this._cachedSize;
        }
        int _size = 0;
        _size += _REQUEST_ID_TAG_SIZE;
        _size += LightProtoCodec.computeVarInt64Size(this.requestId);
        if (this.hasTxnidLeastBits()) {
            _size += _TXNID_LEAST_BITS_TAG_SIZE;
            _size += LightProtoCodec.computeVarInt64Size(this.txnidLeastBits);
        }
        if (this.hasTxnidMostBits()) {
            _size += _TXNID_MOST_BITS_TAG_SIZE;
            _size += LightProtoCodec.computeVarInt64Size(this.txnidMostBits);
        }
        for (int i = 0; i < this._partitionsCount; ++i) {
            LightProtoCodec.StringHolder _sh = this.partitions.get(i);
            _size += _PARTITIONS_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(_sh.len) + _sh.len;
        }
        this._cachedSize = _size;
        return _size;
    }

    public void parseFrom(ByteBuf _buffer, int _size) {
        this.clear();
        int _endIdx = _buffer.readerIndex() + _size;
        block6: while (_buffer.readerIndex() < _endIdx) {
            int _tag = LightProtoCodec.readVarInt(_buffer);
            switch (_tag) {
                case 8: {
                    this._bitField0 |= 1;
                    this.requestId = LightProtoCodec.readVarInt64(_buffer);
                    continue block6;
                }
                case 16: {
                    this._bitField0 |= 2;
                    this.txnidLeastBits = LightProtoCodec.readVarInt64(_buffer);
                    continue block6;
                }
                case 24: {
                    this._bitField0 |= 4;
                    this.txnidMostBits = LightProtoCodec.readVarInt64(_buffer);
                    continue block6;
                }
                case 34: {
                    LightProtoCodec.StringHolder _partitionsSh = this._newPartitionStringHolder();
                    _partitionsSh.len = LightProtoCodec.readVarInt(_buffer);
                    _partitionsSh.idx = _buffer.readerIndex();
                    _buffer.skipBytes(_partitionsSh.len);
                    continue block6;
                }
            }
            LightProtoCodec.skipUnknownField(_tag, _buffer);
        }
        this.checkRequiredFields();
        this._parsedBuffer = _buffer;
    }

    private void checkRequiredFields() {
        if ((this._bitField0 & 1) != 1) {
            throw new IllegalStateException("Some required fields are missing");
        }
    }

    public CommandAddPartitionToTxn clear() {
        this.txnidLeastBits = 0L;
        this.txnidMostBits = 0L;
        for (int i = 0; i < this._partitionsCount; ++i) {
            LightProtoCodec.StringHolder _sh = this.partitions.get(i);
            _sh.s = null;
            _sh.idx = -1;
            _sh.len = -1;
        }
        this._partitionsCount = 0;
        this._parsedBuffer = null;
        this._cachedSize = -1;
        this._bitField0 = 0;
        return this;
    }

    public CommandAddPartitionToTxn copyFrom(CommandAddPartitionToTxn _other) {
        this._cachedSize = -1;
        if (_other.hasRequestId()) {
            this.setRequestId(_other.requestId);
        }
        if (_other.hasTxnidLeastBits()) {
            this.setTxnidLeastBits(_other.txnidLeastBits);
        }
        if (_other.hasTxnidMostBits()) {
            this.setTxnidMostBits(_other.txnidMostBits);
        }
        for (int i = 0; i < _other.getPartitionsCount(); ++i) {
            this.addPartition(_other.getPartitionAt(i));
        }
        return this;
    }

    public byte[] toByteArray() {
        byte[] a = new byte[this.getSerializedSize()];
        ByteBuf b = Unpooled.wrappedBuffer(a).writerIndex(0);
        this.writeTo(b);
        return a;
    }

    public void parseFrom(byte[] a) {
        ByteBuf b = Unpooled.wrappedBuffer(a);
        this.parseFrom(b, b.readableBytes());
    }
}

