/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.transaction;

import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.PulsarClientException;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.transaction.Transaction;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.transaction.TransactionBuilder;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.PulsarClientImpl;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.transaction.TransactionCoordinatorClientImpl;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.transaction.TransactionImpl;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.util.FutureUtil;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionBuilderImpl
implements TransactionBuilder {
    private static final Logger log = LoggerFactory.getLogger(TransactionBuilderImpl.class);
    private final PulsarClientImpl client;
    private final TransactionCoordinatorClientImpl transactionCoordinatorClient;
    private long txnTimeout = 60000L;
    private TimeUnit timeUnit = TimeUnit.MILLISECONDS;

    public TransactionBuilderImpl(PulsarClientImpl client, TransactionCoordinatorClientImpl tcClient) {
        this.client = client;
        this.transactionCoordinatorClient = tcClient;
    }

    @Override
    public TransactionBuilder withTransactionTimeout(long txnTimeout, TimeUnit timeoutUnit) {
        this.txnTimeout = txnTimeout;
        this.timeUnit = timeoutUnit;
        return this;
    }

    @Override
    public CompletableFuture<Transaction> build() {
        if (!this.client.getConfiguration().isEnableTransaction()) {
            return FutureUtil.failedFuture(new PulsarClientException.InvalidConfigurationException("Transactions are not enabled"));
        }
        CompletableFuture<Transaction> future = new CompletableFuture<Transaction>();
        this.transactionCoordinatorClient.newTransactionAsync(this.txnTimeout, this.timeUnit).whenComplete((txnID, throwable) -> {
            if (throwable != null) {
                log.error("New transaction error.", (Throwable)throwable);
                future.completeExceptionally((Throwable)throwable);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("'newTransaction' command completed successfully for transaction: {}", txnID);
            }
            TransactionImpl transaction = new TransactionImpl(this.client, this.timeUnit.toMillis(this.txnTimeout), txnID.getLeastSigBits(), txnID.getMostSigBits());
            future.complete(transaction);
        });
        return future;
    }
}

