/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.schema.generic;

import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.schema.GenericRecord;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.schema.SchemaReader;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.schema.ProtobufNativeSchemaUtils;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.schema.SchemaUtils;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.schema.generic.GenericProtobufNativeReader;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.schema.reader.AbstractMultiVersionReader;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.protocol.schema.BytesSchemaVersion;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.schema.SchemaInfo;
import com.google.protobuf.Descriptors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiVersionGenericProtobufNativeReader
extends AbstractMultiVersionReader<GenericRecord>
implements SchemaReader<GenericRecord> {
    private static final Logger log = LoggerFactory.getLogger(MultiVersionGenericProtobufNativeReader.class);
    private final boolean useProvidedSchemaAsReaderSchema;
    private final SchemaInfo schemaInfo;
    private final Descriptors.Descriptor descriptor;

    public MultiVersionGenericProtobufNativeReader(boolean useProvidedSchemaAsReaderSchema, SchemaInfo schemaInfo) {
        super(new GenericProtobufNativeReader(MultiVersionGenericProtobufNativeReader.parseProtobufSchema(schemaInfo)));
        this.useProvidedSchemaAsReaderSchema = useProvidedSchemaAsReaderSchema;
        this.schemaInfo = schemaInfo;
        this.descriptor = (Descriptors.Descriptor)this.providerSchemaReader.getNativeSchema().orElseThrow(() -> {
            log.error("No protobuf native reader found.");
            return new IllegalArgumentException("No protobuf native reader found.");
        });
    }

    @Override
    protected SchemaReader<GenericRecord> loadReader(BytesSchemaVersion schemaVersion) {
        SchemaInfo schemaInfo = this.getSchemaInfoByVersion(schemaVersion.get());
        if (schemaInfo != null) {
            log.info("Load schema reader for version({}), schema is : {}", (Object)SchemaUtils.getStringSchemaVersion(schemaVersion.get()), (Object)schemaInfo);
            Descriptors.Descriptor recordDescriptor = MultiVersionGenericProtobufNativeReader.parseProtobufSchema(schemaInfo);
            Descriptors.Descriptor readerSchemaDescriptor = this.useProvidedSchemaAsReaderSchema ? this.descriptor : recordDescriptor;
            return new GenericProtobufNativeReader(readerSchemaDescriptor, schemaVersion.get());
        }
        log.warn("No schema found for version({}), use latest schema : {}", (Object)SchemaUtils.getStringSchemaVersion(schemaVersion.get()), (Object)this.schemaInfo);
        return this.providerSchemaReader;
    }

    protected static Descriptors.Descriptor parseProtobufSchema(SchemaInfo schemaInfo) {
        return ProtobufNativeSchemaUtils.deserialize(schemaInfo.getSchema());
    }
}

