/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.schema.generic;

import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.schema.GenericRecord;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.schema.SchemaReader;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.schema.SchemaUtils;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.schema.generic.AbstractMultiVersionGenericReader;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.schema.generic.GenericAvroReader;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.schema.util.SchemaUtil;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.protocol.schema.BytesSchemaVersion;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.shade.org.apache.avro.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiVersionGenericAvroReader
extends AbstractMultiVersionGenericReader {
    protected static final Logger LOG = LoggerFactory.getLogger(MultiVersionGenericAvroReader.class);

    public MultiVersionGenericAvroReader(boolean useProvidedSchemaAsReaderSchema, Schema readerSchema) {
        super(useProvidedSchemaAsReaderSchema, new GenericAvroReader(readerSchema), readerSchema);
    }

    @Override
    protected SchemaReader<GenericRecord> loadReader(BytesSchemaVersion schemaVersion) {
        SchemaInfo schemaInfo = this.getSchemaInfoByVersion(schemaVersion.get());
        if (schemaInfo != null) {
            LOG.info("Load schema reader for version({}), schema is : {}", (Object)SchemaUtils.getStringSchemaVersion(schemaVersion.get()), (Object)schemaInfo);
            Schema writerSchema = SchemaUtil.parseAvroSchema(schemaInfo.getSchemaDefinition());
            Schema readerSchema = this.useProvidedSchemaAsReaderSchema ? this.readerSchema : writerSchema;
            readerSchema.addProp("__AVRO_READ_OFFSET__", schemaInfo.getProperties().getOrDefault("__AVRO_READ_OFFSET__", "0"));
            return new GenericAvroReader(writerSchema, readerSchema, schemaVersion.get());
        }
        LOG.warn("No schema found for version({}), use latest schema : {}", (Object)SchemaUtils.getStringSchemaVersion(schemaVersion.get()), (Object)this.readerSchema);
        return this.providerSchemaReader;
    }
}

