/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.schema.generic;

import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.SchemaSerializationException;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.schema.GenericRecord;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.schema.SchemaWriter;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.schema.generic.GenericAvroRecord;
import java.io.ByteArrayOutputStream;
import org.apache.pulsar.shade.org.apache.avro.Schema;
import org.apache.pulsar.shade.org.apache.avro.generic.GenericDatumWriter;
import org.apache.pulsar.shade.org.apache.avro.io.BinaryEncoder;
import org.apache.pulsar.shade.org.apache.avro.io.EncoderFactory;

public class GenericAvroWriter
implements SchemaWriter<GenericRecord> {
    private final GenericDatumWriter<org.apache.pulsar.shade.org.apache.avro.generic.GenericRecord> writer;
    private BinaryEncoder encoder;
    private final ByteArrayOutputStream byteArrayOutputStream;

    public GenericAvroWriter(Schema schema) {
        this.writer = new GenericDatumWriter(schema);
        this.byteArrayOutputStream = new ByteArrayOutputStream();
        this.encoder = EncoderFactory.get().binaryEncoder(this.byteArrayOutputStream, null);
    }

    @Override
    public synchronized byte[] write(GenericRecord message) {
        try {
            this.writer.write(((GenericAvroRecord)message).getAvroRecord(), this.encoder);
            this.encoder.flush();
            byte[] byArray = this.byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new SchemaSerializationException(e);
        }
        finally {
            this.byteArrayOutputStream.reset();
        }
    }
}

