/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.schema;

import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.schema.AbstractSchema;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.schema.LongSchema;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.schema.SchemaInfoImpl;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.schema.SchemaInfo;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.schema.SchemaType;
import java.time.LocalTime;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;

public class LocalTimeSchema
extends AbstractSchema<LocalTime> {
    private static final LocalTimeSchema INSTANCE;
    private static final SchemaInfo SCHEMA_INFO;

    public static LocalTimeSchema of() {
        return INSTANCE;
    }

    @Override
    public byte[] encode(LocalTime message) {
        if (null == message) {
            return null;
        }
        Long nanoOfDay = message.toNanoOfDay();
        return LongSchema.of().encode(nanoOfDay);
    }

    @Override
    public LocalTime decode(byte[] bytes) {
        if (null == bytes) {
            return null;
        }
        Long decode = LongSchema.of().decode(bytes);
        return LocalTime.ofNanoOfDay(decode);
    }

    @Override
    public LocalTime decode(ByteBuf byteBuf) {
        if (null == byteBuf) {
            return null;
        }
        Long decode = LongSchema.of().decode(byteBuf);
        return LocalTime.ofNanoOfDay(decode);
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        return SCHEMA_INFO;
    }

    static {
        SCHEMA_INFO = SchemaInfoImpl.builder().name("LocalTime").type(SchemaType.LOCAL_TIME).schema(new byte[0]).build();
        INSTANCE = new LocalTimeSchema();
    }
}

