/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.schema;

import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.schema.AbstractSchema;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.schema.LongSchema;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.schema.SchemaInfoImpl;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.schema.SchemaInfo;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.schema.SchemaType;
import java.time.LocalDate;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;

public class LocalDateSchema
extends AbstractSchema<LocalDate> {
    private static final LocalDateSchema INSTANCE;
    private static final SchemaInfo SCHEMA_INFO;

    public static LocalDateSchema of() {
        return INSTANCE;
    }

    @Override
    public byte[] encode(LocalDate message) {
        if (null == message) {
            return null;
        }
        Long epochDay = message.toEpochDay();
        return LongSchema.of().encode(epochDay);
    }

    @Override
    public LocalDate decode(byte[] bytes) {
        if (null == bytes) {
            return null;
        }
        Long decode = LongSchema.of().decode(bytes);
        return LocalDate.ofEpochDay(decode);
    }

    @Override
    public LocalDate decode(ByteBuf byteBuf) {
        if (null == byteBuf) {
            return null;
        }
        Long decode = LongSchema.of().decode(byteBuf);
        return LocalDate.ofEpochDay(decode);
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        return SCHEMA_INFO;
    }

    static {
        SCHEMA_INFO = SchemaInfoImpl.builder().name("LocalDate").type(SchemaType.LOCAL_DATE).schema(new byte[0]).build();
        INSTANCE = new LocalDateSchema();
    }
}

