/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.schema;

import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.Schema;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.schema.SchemaInfoImpl;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.schema.SchemaUtils;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.schema.KeyValue;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.schema.KeyValueEncodingType;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.schema.SchemaInfo;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.schema.SchemaType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KeyValueSchemaInfo {
    private static final Logger log = LoggerFactory.getLogger(KeyValueSchemaInfo.class);
    private static final Schema<SchemaInfo> SCHEMA_INFO_WRITER = new Schema<SchemaInfo>(){

        @Override
        public byte[] encode(SchemaInfo si) {
            return si.getSchema();
        }

        @Override
        public SchemaInfo getSchemaInfo() {
            return Schema.BYTES.getSchemaInfo();
        }

        @Override
        public Schema<SchemaInfo> clone() {
            return this;
        }
    };
    private static final String KEY_SCHEMA_NAME = "key.schema.name";
    private static final String KEY_SCHEMA_TYPE = "key.schema.type";
    private static final String KEY_SCHEMA_PROPS = "key.schema.properties";
    private static final String VALUE_SCHEMA_NAME = "value.schema.name";
    private static final String VALUE_SCHEMA_TYPE = "value.schema.type";
    private static final String VALUE_SCHEMA_PROPS = "value.schema.properties";
    private static final String KV_ENCODING_TYPE = "kv.encoding.type";

    public static KeyValueEncodingType decodeKeyValueEncodingType(SchemaInfo schemaInfo) {
        Preconditions.checkArgument(SchemaType.KEY_VALUE == schemaInfo.getType(), "Not a KeyValue schema");
        String encodingTypeStr = schemaInfo.getProperties().get(KV_ENCODING_TYPE);
        if (StringUtils.isEmpty(encodingTypeStr)) {
            return KeyValueEncodingType.INLINE;
        }
        return KeyValueEncodingType.valueOf(encodingTypeStr);
    }

    public static <K, V> SchemaInfo encodeKeyValueSchemaInfo(Schema<K> keySchema, Schema<V> valueSchema, KeyValueEncodingType keyValueEncodingType) {
        return KeyValueSchemaInfo.encodeKeyValueSchemaInfo("KeyValue", keySchema, valueSchema, keyValueEncodingType);
    }

    public static <K, V> SchemaInfo encodeKeyValueSchemaInfo(String schemaName, Schema<K> keySchema, Schema<V> valueSchema, KeyValueEncodingType keyValueEncodingType) {
        return KeyValueSchemaInfo.encodeKeyValueSchemaInfo(schemaName, keySchema.getSchemaInfo(), valueSchema.getSchemaInfo(), keyValueEncodingType);
    }

    public static SchemaInfo encodeKeyValueSchemaInfo(String schemaName, SchemaInfo keySchemaInfo, SchemaInfo valueSchemaInfo, KeyValueEncodingType keyValueEncodingType) {
        Objects.requireNonNull(keyValueEncodingType, "Null encoding type is provided");
        if (keySchemaInfo == null || valueSchemaInfo == null) {
            return null;
        }
        byte[] schemaData = KeyValue.encode(keySchemaInfo, SCHEMA_INFO_WRITER, valueSchemaInfo, SCHEMA_INFO_WRITER);
        HashMap<String, String> properties = new HashMap<String, String>();
        KeyValueSchemaInfo.encodeSubSchemaInfoToParentSchemaProperties(keySchemaInfo, KEY_SCHEMA_NAME, KEY_SCHEMA_TYPE, KEY_SCHEMA_PROPS, properties);
        KeyValueSchemaInfo.encodeSubSchemaInfoToParentSchemaProperties(valueSchemaInfo, VALUE_SCHEMA_NAME, VALUE_SCHEMA_TYPE, VALUE_SCHEMA_PROPS, properties);
        properties.put(KV_ENCODING_TYPE, String.valueOf((Object)keyValueEncodingType));
        return SchemaInfoImpl.builder().name(schemaName).type(SchemaType.KEY_VALUE).schema(schemaData).properties(properties).build();
    }

    private static void encodeSubSchemaInfoToParentSchemaProperties(SchemaInfo schemaInfo, String schemaNameProperty, String schemaTypeProperty, String schemaPropsProperty, Map<String, String> parentSchemaProperties) {
        parentSchemaProperties.put(schemaNameProperty, schemaInfo.getName());
        parentSchemaProperties.put(schemaTypeProperty, String.valueOf((Object)schemaInfo.getType()));
        parentSchemaProperties.put(schemaPropsProperty, SchemaUtils.serializeSchemaProperties(schemaInfo.getProperties()));
    }

    public static KeyValue<SchemaInfo, SchemaInfo> decodeKeyValueSchemaInfo(SchemaInfo schemaInfo) {
        Preconditions.checkArgument(SchemaType.KEY_VALUE == schemaInfo.getType(), "Not a KeyValue schema");
        return KeyValue.decode(schemaInfo.getSchema(), (keyBytes, valueBytes) -> {
            SchemaInfo keySchemaInfo = KeyValueSchemaInfo.decodeSubSchemaInfo(schemaInfo, KEY_SCHEMA_NAME, KEY_SCHEMA_TYPE, KEY_SCHEMA_PROPS, keyBytes);
            SchemaInfo valueSchemaInfo = KeyValueSchemaInfo.decodeSubSchemaInfo(schemaInfo, VALUE_SCHEMA_NAME, VALUE_SCHEMA_TYPE, VALUE_SCHEMA_PROPS, valueBytes);
            return new KeyValue<SchemaInfo, SchemaInfo>(keySchemaInfo, valueSchemaInfo);
        });
    }

    private static SchemaInfo decodeSubSchemaInfo(SchemaInfo parentSchemaInfo, String schemaNameProperty, String schemaTypeProperty, String schemaPropsProperty, byte[] schemaData) {
        Map<String, String> parentSchemaProps = parentSchemaInfo.getProperties();
        String schemaName = parentSchemaProps.getOrDefault(schemaNameProperty, "");
        SchemaType schemaType = SchemaType.valueOf(parentSchemaProps.getOrDefault(schemaTypeProperty, SchemaType.BYTES.name()));
        String schemaPropsStr = parentSchemaProps.get(schemaPropsProperty);
        Map<Object, Object> schemaProps = StringUtils.isEmpty(schemaPropsStr) ? Collections.emptyMap() : SchemaUtils.deserializeSchemaProperties(schemaPropsStr);
        return SchemaInfoImpl.builder().name(schemaName).type(schemaType).schema(schemaData).properties(schemaProps).build();
    }

    private KeyValueSchemaInfo() {
    }
}

