/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.schema;

import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.SchemaSerializationException;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.schema.AbstractSchema;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.schema.SchemaInfoImpl;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.schema.SchemaInfo;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;

public class IntSchema
extends AbstractSchema<Integer> {
    private static final IntSchema INSTANCE;
    private static final SchemaInfo SCHEMA_INFO;

    public static IntSchema of() {
        return INSTANCE;
    }

    @Override
    public void validate(byte[] message) {
        if (message.length != 4) {
            throw new SchemaSerializationException("Size of data received by IntSchema is not 4");
        }
    }

    @Override
    public void validate(ByteBuf message) {
        if (message.readableBytes() != 4) {
            throw new SchemaSerializationException("Size of data received by IntSchema is not 4");
        }
    }

    @Override
    public byte[] encode(Integer message) {
        if (null == message) {
            return null;
        }
        return new byte[]{(byte)(message >>> 24), (byte)(message >>> 16), (byte)(message >>> 8), message.byteValue()};
    }

    @Override
    public Integer decode(byte[] bytes) {
        if (null == bytes) {
            return null;
        }
        this.validate(bytes);
        int value = 0;
        for (byte b : bytes) {
            value <<= 8;
            value |= b & 0xFF;
        }
        return value;
    }

    @Override
    public Integer decode(ByteBuf byteBuf) {
        if (null == byteBuf) {
            return null;
        }
        this.validate(byteBuf);
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            value <<= 8;
            value |= byteBuf.getByte(i) & 0xFF;
        }
        return value;
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        return SCHEMA_INFO;
    }

    static {
        SCHEMA_INFO = SchemaInfoImpl.builder().name("INT32").type(SchemaType.INT32).schema(new byte[0]).build();
        INSTANCE = new IntSchema();
    }
}

