/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.schema;

import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.schema.Field;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.schema.GenericRecord;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.classification.InterfaceAudience;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.classification.InterfaceStability;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.schema.SchemaType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class GenericObjectWrapper
implements GenericRecord {
    private final Object nativeObject;
    private final SchemaType schemaType;
    private final byte[] schemaVersion;

    static GenericObjectWrapper of(Object nativeObject, SchemaType schemaType, byte[] schemaVersion) {
        return new GenericObjectWrapper(nativeObject, schemaType, schemaVersion);
    }

    private GenericObjectWrapper(Object nativeObject, SchemaType schemaType, byte[] schemaVersion) {
        this.nativeObject = nativeObject;
        this.schemaType = Objects.requireNonNull(schemaType, "SchemaType is required");
        this.schemaVersion = schemaVersion;
    }

    @Override
    public byte[] getSchemaVersion() {
        return this.schemaVersion;
    }

    @Override
    public List<Field> getFields() {
        return Collections.emptyList();
    }

    @Override
    public Object getField(String fieldName) {
        return null;
    }

    @Override
    public SchemaType getSchemaType() {
        return this.schemaType;
    }

    @Override
    public Object getNativeObject() {
        return this.nativeObject;
    }

    public String toString() {
        return Objects.toString(this.nativeObject);
    }

    public int hashCode() {
        return Objects.hashCode(this.nativeObject);
    }

    public boolean equals(Object other) {
        if (!(other instanceof GenericObjectWrapper)) {
            return false;
        }
        GenericObjectWrapper gw = (GenericObjectWrapper)other;
        return this.schemaType == gw.schemaType && Objects.equals(this.nativeObject, gw.nativeObject) && Arrays.equals(this.schemaVersion, gw.schemaVersion);
    }
}

