/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.schema;

import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.schema.AbstractSchema;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.schema.LongSchema;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.schema.SchemaInfoImpl;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.schema.SchemaInfo;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.schema.SchemaType;
import java.util.Date;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;

public class DateSchema
extends AbstractSchema<Date> {
    private static final DateSchema INSTANCE;
    private static final SchemaInfo SCHEMA_INFO;

    public static DateSchema of() {
        return INSTANCE;
    }

    @Override
    public byte[] encode(Date message) {
        if (null == message) {
            return null;
        }
        Long date = message.getTime();
        return LongSchema.of().encode(date);
    }

    @Override
    public Date decode(byte[] bytes) {
        if (null == bytes) {
            return null;
        }
        Long decode = LongSchema.of().decode(bytes);
        return new Date(decode);
    }

    @Override
    public Date decode(ByteBuf byteBuf) {
        if (null == byteBuf) {
            return null;
        }
        Long decode = LongSchema.of().decode(byteBuf);
        return new Date(decode);
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        return SCHEMA_INFO;
    }

    static {
        SCHEMA_INFO = SchemaInfoImpl.builder().name("Date").type(SchemaType.DATE).schema(new byte[0]).build();
        INSTANCE = new DateSchema();
    }
}

