/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.schema;

import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.Schema;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.schema.KeyValueSchema;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.schema.KeyValueEncodingType;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.schema.SchemaInfo;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.schema.SchemaType;
import java.util.Optional;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;

public class AutoProduceBytesSchema<T>
implements Schema<byte[]> {
    private boolean requireSchemaValidation = true;
    private Schema<T> schema;

    public AutoProduceBytesSchema() {
    }

    public AutoProduceBytesSchema(Schema<T> schema) {
        this.schema = schema;
        SchemaInfo schemaInfo = schema.getSchemaInfo();
        this.requireSchemaValidation = schemaInfo != null && schemaInfo.getType() != SchemaType.BYTES && schemaInfo.getType() != SchemaType.NONE;
    }

    public void setSchema(Schema<T> schema) {
        this.schema = schema;
        this.requireSchemaValidation = schema.getSchemaInfo() != null && SchemaType.BYTES != schema.getSchemaInfo().getType() && SchemaType.NONE != schema.getSchemaInfo().getType();
    }

    private void ensureSchemaInitialized() {
        Preconditions.checkState(this.schemaInitialized(), "Schema is not initialized before used");
    }

    public boolean schemaInitialized() {
        return this.schema != null;
    }

    @Override
    public void validate(byte[] message) {
        this.ensureSchemaInitialized();
        this.schema.validate(message);
    }

    @Override
    public byte[] encode(byte[] message) {
        this.ensureSchemaInitialized();
        if (this.requireSchemaValidation) {
            if (this.schema instanceof KeyValueSchema && ((KeyValueSchema)this.schema).getKeyValueEncodingType().equals((Object)KeyValueEncodingType.SEPARATED)) {
                ((KeyValueSchema)this.schema).getValueSchema().validate(message);
            } else {
                this.schema.validate(message);
            }
        }
        return message;
    }

    @Override
    public byte[] decode(byte[] bytes, byte[] schemaVersion) {
        this.ensureSchemaInitialized();
        if (this.requireSchemaValidation) {
            this.schema.decode(bytes, schemaVersion);
        }
        return bytes;
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        this.ensureSchemaInitialized();
        return this.schema.getSchemaInfo();
    }

    @Override
    public Optional<Object> getNativeSchema() {
        return Optional.ofNullable(this.schema);
    }

    @Override
    public Schema<byte[]> clone() {
        return new AutoProduceBytesSchema<T>(this.schema.clone());
    }
}

