/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.customroute;

import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.Message;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.MessageRouter;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.TopicMetadata;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.util.MathUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class PartialRoundRobinMessageRouterImpl
implements MessageRouter {
    private final int numPartitionsLimit;
    private final List<Integer> partialList = new CopyOnWriteArrayList<Integer>();
    private static final AtomicIntegerFieldUpdater<PartialRoundRobinMessageRouterImpl> PARTITION_INDEX_UPDATER = AtomicIntegerFieldUpdater.newUpdater(PartialRoundRobinMessageRouterImpl.class, "partitionIndex");
    private volatile int partitionIndex = 0;

    public PartialRoundRobinMessageRouterImpl(int numPartitionsLimit) {
        if (numPartitionsLimit < 1) {
            throw new IllegalArgumentException("numPartitionsLimit should be greater than or equal to 1");
        }
        this.numPartitionsLimit = numPartitionsLimit;
    }

    @Override
    public int choosePartition(Message<?> msg, TopicMetadata metadata) {
        ArrayList<Integer> newPartialList = new ArrayList<Integer>(this.getOrCreatePartialList(metadata));
        return (Integer)newPartialList.get(MathUtils.signSafeMod(PARTITION_INDEX_UPDATER.getAndIncrement(this), newPartialList.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Integer> getOrCreatePartialList(TopicMetadata metadata) {
        if (this.partialList.isEmpty() || this.partialList.size() < this.numPartitionsLimit && this.partialList.size() < metadata.numPartitions()) {
            PartialRoundRobinMessageRouterImpl partialRoundRobinMessageRouterImpl = this;
            synchronized (partialRoundRobinMessageRouterImpl) {
                if (this.partialList.isEmpty()) {
                    this.partialList.addAll(IntStream.range(0, metadata.numPartitions()).boxed().collect(Collectors.collectingAndThen(Collectors.toList(), list -> {
                        Collections.shuffle(list);
                        return list.stream();
                    })).limit(this.numPartitionsLimit).collect(Collectors.toList()));
                } else if (this.partialList.size() < this.numPartitionsLimit && this.partialList.size() < metadata.numPartitions()) {
                    this.partialList.addAll(IntStream.range(0, metadata.numPartitions()).boxed().filter(e -> !this.partialList.contains(e)).collect(Collectors.collectingAndThen(Collectors.toList(), list -> {
                        Collections.shuffle(list);
                        return list.stream();
                    })).limit(this.numPartitionsLimit - this.partialList.size()).collect(Collectors.toList()));
                }
            }
        }
        return this.partialList;
    }
}

