/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.conf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public class DefaultCryptoKeyReaderConfigurationData
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final String TO_STRING_FORMAT = "%s(defaultPublicKey=%s, defaultPrivateKey=%s, publicKeys=%s, privateKeys=%s)";
    @NonNull
    private String defaultPublicKey;
    @NonNull
    private String defaultPrivateKey;
    @NonNull
    private Map<String, String> publicKeys = new HashMap<String, String>();
    @NonNull
    private Map<String, String> privateKeys = new HashMap<String, String>();

    public void setPublicKey(@NonNull String keyName, @NonNull String publicKey) {
        if (keyName == null) {
            throw new NullPointerException("keyName is marked non-null but is null");
        }
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        this.publicKeys.put(keyName, publicKey);
    }

    public void setPrivateKey(@NonNull String keyName, @NonNull String privateKey) {
        if (keyName == null) {
            throw new NullPointerException("keyName is marked non-null but is null");
        }
        if (privateKey == null) {
            throw new NullPointerException("privateKey is marked non-null but is null");
        }
        this.privateKeys.put(keyName, privateKey);
    }

    public DefaultCryptoKeyReaderConfigurationData clone() {
        DefaultCryptoKeyReaderConfigurationData clone = new DefaultCryptoKeyReaderConfigurationData();
        if (this.defaultPublicKey != null) {
            clone.setDefaultPublicKey(this.defaultPublicKey);
        }
        if (this.defaultPrivateKey != null) {
            clone.setDefaultPrivateKey(this.defaultPrivateKey);
        }
        if (this.publicKeys != null) {
            clone.setPublicKeys(new HashMap<String, String>(this.publicKeys));
        }
        if (this.privateKeys != null) {
            clone.setPrivateKeys(new HashMap<String, String>(this.privateKeys));
        }
        return clone;
    }

    public String toString() {
        return String.format(TO_STRING_FORMAT, this.getClass().getSimpleName(), DefaultCryptoKeyReaderConfigurationData.maskKeyData(this.defaultPublicKey), DefaultCryptoKeyReaderConfigurationData.maskKeyData(this.defaultPrivateKey), DefaultCryptoKeyReaderConfigurationData.maskKeyData(this.publicKeys), DefaultCryptoKeyReaderConfigurationData.maskKeyData(this.privateKeys));
    }

    private static String maskKeyData(Map<String, String> keys) {
        if (keys == null) {
            return "null";
        }
        StringBuilder keysStr = new StringBuilder();
        keysStr.append("{");
        ArrayList kvList = new ArrayList();
        keys.forEach((k, v) -> kvList.add(k + "=" + DefaultCryptoKeyReaderConfigurationData.maskKeyData(v)));
        keysStr.append(String.join((CharSequence)", ", kvList));
        keysStr.append("}");
        return keysStr.toString();
    }

    private static String maskKeyData(String key) {
        if (key == null) {
            return "null";
        }
        if (key.startsWith("data:")) {
            return "data:*****";
        }
        return key;
    }

    @NonNull
    public String getDefaultPublicKey() {
        return this.defaultPublicKey;
    }

    @NonNull
    public String getDefaultPrivateKey() {
        return this.defaultPrivateKey;
    }

    @NonNull
    public Map<String, String> getPublicKeys() {
        return this.publicKeys;
    }

    @NonNull
    public Map<String, String> getPrivateKeys() {
        return this.privateKeys;
    }

    public void setDefaultPublicKey(@NonNull String defaultPublicKey) {
        if (defaultPublicKey == null) {
            throw new NullPointerException("defaultPublicKey is marked non-null but is null");
        }
        this.defaultPublicKey = defaultPublicKey;
    }

    public void setDefaultPrivateKey(@NonNull String defaultPrivateKey) {
        if (defaultPrivateKey == null) {
            throw new NullPointerException("defaultPrivateKey is marked non-null but is null");
        }
        this.defaultPrivateKey = defaultPrivateKey;
    }

    public void setPublicKeys(@NonNull Map<String, String> publicKeys) {
        if (publicKeys == null) {
            throw new NullPointerException("publicKeys is marked non-null but is null");
        }
        this.publicKeys = publicKeys;
    }

    public void setPrivateKeys(@NonNull Map<String, String> privateKeys) {
        if (privateKeys == null) {
            throw new NullPointerException("privateKeys is marked non-null but is null");
        }
        this.privateKeys = privateKeys;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultCryptoKeyReaderConfigurationData)) {
            return false;
        }
        DefaultCryptoKeyReaderConfigurationData other = (DefaultCryptoKeyReaderConfigurationData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$defaultPublicKey = this.getDefaultPublicKey();
        String other$defaultPublicKey = other.getDefaultPublicKey();
        if (this$defaultPublicKey == null ? other$defaultPublicKey != null : !this$defaultPublicKey.equals(other$defaultPublicKey)) {
            return false;
        }
        String this$defaultPrivateKey = this.getDefaultPrivateKey();
        String other$defaultPrivateKey = other.getDefaultPrivateKey();
        if (this$defaultPrivateKey == null ? other$defaultPrivateKey != null : !this$defaultPrivateKey.equals(other$defaultPrivateKey)) {
            return false;
        }
        Map<String, String> this$publicKeys = this.getPublicKeys();
        Map<String, String> other$publicKeys = other.getPublicKeys();
        if (this$publicKeys == null ? other$publicKeys != null : !((Object)this$publicKeys).equals(other$publicKeys)) {
            return false;
        }
        Map<String, String> this$privateKeys = this.getPrivateKeys();
        Map<String, String> other$privateKeys = other.getPrivateKeys();
        return !(this$privateKeys == null ? other$privateKeys != null : !((Object)this$privateKeys).equals(other$privateKeys));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultCryptoKeyReaderConfigurationData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $defaultPublicKey = this.getDefaultPublicKey();
        result = result * 59 + ($defaultPublicKey == null ? 43 : $defaultPublicKey.hashCode());
        String $defaultPrivateKey = this.getDefaultPrivateKey();
        result = result * 59 + ($defaultPrivateKey == null ? 43 : $defaultPrivateKey.hashCode());
        Map<String, String> $publicKeys = this.getPublicKeys();
        result = result * 59 + ($publicKeys == null ? 43 : ((Object)$publicKeys).hashCode());
        Map<String, String> $privateKeys = this.getPrivateKeys();
        result = result * 59 + ($privateKeys == null ? 43 : ((Object)$privateKeys).hashCode());
        return result;
    }

    public DefaultCryptoKeyReaderConfigurationData() {
    }

    public DefaultCryptoKeyReaderConfigurationData(@NonNull String defaultPublicKey, @NonNull String defaultPrivateKey, @NonNull Map<String, String> publicKeys, @NonNull Map<String, String> privateKeys) {
        if (defaultPublicKey == null) {
            throw new NullPointerException("defaultPublicKey is marked non-null but is null");
        }
        if (defaultPrivateKey == null) {
            throw new NullPointerException("defaultPrivateKey is marked non-null but is null");
        }
        if (publicKeys == null) {
            throw new NullPointerException("publicKeys is marked non-null but is null");
        }
        if (privateKeys == null) {
            throw new NullPointerException("privateKeys is marked non-null but is null");
        }
        this.defaultPublicKey = defaultPublicKey;
        this.defaultPrivateKey = defaultPrivateKey;
        this.publicKeys = publicKeys;
        this.privateKeys = privateKeys;
    }
}

