/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.auth.oauth2;

import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.AuthenticationDataProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class AuthenticationDataOAuth2
implements AuthenticationDataProvider {
    public static final String HTTP_HEADER_NAME = "Authorization";
    private final String accessToken;
    private Map<String, String> headers = new HashMap<String, String>();

    public AuthenticationDataOAuth2(String accessToken) {
        this.accessToken = accessToken;
        this.headers.put(HTTP_HEADER_NAME, "Bearer " + accessToken);
        this.headers.put("X-Pulsar-Auth-Method-Name", "token");
        this.headers = Collections.unmodifiableMap(this.headers);
    }

    @Override
    public boolean hasDataForHttp() {
        return true;
    }

    @Override
    public Set<Map.Entry<String, String>> getHttpHeaders() {
        return this.headers.entrySet();
    }

    @Override
    public boolean hasDataFromCommand() {
        return true;
    }

    @Override
    public String getCommandData() {
        return this.accessToken;
    }
}

