/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.auth;

import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.AuthenticationDataProvider;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class AuthenticationDataBasic
implements AuthenticationDataProvider {
    private static final String HTTP_HEADER_NAME = "Authorization";
    private final String commandAuthToken;
    private final Map<String, String> headers;

    public AuthenticationDataBasic(String userId, String password) {
        this(userId + ":" + password);
    }

    public AuthenticationDataBasic(String userInfo) {
        final String httpAuthToken = "Basic " + Base64.getEncoder().encodeToString(userInfo.getBytes());
        this.commandAuthToken = userInfo;
        this.headers = Collections.unmodifiableMap(new HashMap<String, String>(){
            {
                this.put(AuthenticationDataBasic.HTTP_HEADER_NAME, httpAuthToken);
                this.put("X-Pulsar-Auth-Method-Name", "basic");
            }
        });
    }

    @Override
    public boolean hasDataForHttp() {
        return true;
    }

    @Override
    public Set<Map.Entry<String, String>> getHttpHeaders() {
        return this.headers.entrySet();
    }

    @Override
    public boolean hasDataFromCommand() {
        return true;
    }

    @Override
    public String getCommandData() {
        return this.commandAuthToken;
    }
}

