/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.auth;

import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.Authentication;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.AuthenticationDataProvider;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.EncodedAuthenticationParameterSupport;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.PulsarClientException;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.auth.AuthenticationDataBasic;
import java.io.IOException;
import java.util.Map;
import org.apache.pulsar.shade.com.google.gson.Gson;
import org.apache.pulsar.shade.com.google.gson.JsonObject;

public class AuthenticationBasic
implements Authentication,
EncodedAuthenticationParameterSupport {
    static final String AUTH_METHOD_NAME = "basic";
    private String userId;
    private String password;

    @Override
    public void close() throws IOException {
    }

    @Override
    public String getAuthMethodName() {
        return AUTH_METHOD_NAME;
    }

    @Override
    public AuthenticationDataProvider getAuthData() throws PulsarClientException {
        try {
            return new AuthenticationDataBasic(this.userId, this.password);
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap(e);
        }
    }

    @Override
    public void configure(Map<String, String> authParams) {
        this.configure(new Gson().toJson(authParams));
    }

    @Override
    public void configure(String encodedAuthParamString) {
        JsonObject params = new Gson().fromJson(encodedAuthParamString, JsonObject.class);
        this.userId = params.get("userId").getAsString();
        this.password = params.get("password").getAsString();
    }

    @Override
    public void start() throws PulsarClientException {
    }
}

