/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl;

import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.HashingScheme;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.Message;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.TopicMetadata;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.MessageRouterBase;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.util.MathUtils;

public class SinglePartitionMessageRouterImpl
extends MessageRouterBase {
    private static final long serialVersionUID = 1L;
    private final int partitionIndex;

    public SinglePartitionMessageRouterImpl(int partitionIndex, HashingScheme hashingScheme) {
        super(hashingScheme);
        this.partitionIndex = partitionIndex;
    }

    @Override
    public int choosePartition(Message<?> msg, TopicMetadata metadata) {
        if (msg.hasKey()) {
            return MathUtils.signSafeMod(this.hash.makeHash(msg.getKey()), metadata.numPartitions());
        }
        return this.partitionIndex;
    }
}

